/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.models.internal.SimpleClassDetails;
import org.hibernate.models.internal.util.IndexedConsumer;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableScope;

public interface ClassDetails
extends AnnotationTarget,
TypeVariableScope {
    public static final ClassDetails OBJECT_CLASS_DETAILS;
    public static final ClassDetails CLASS_CLASS_DETAILS;
    public static final ClassDetails VOID_CLASS_DETAILS;
    public static final ClassDetails VOID_OBJECT_CLASS_DETAILS;

    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.CLASS;
    }

    @Override
    public String getName();

    public String getClassName();

    public boolean isResolved();

    public boolean isAbstract();

    public boolean isRecord();

    public ClassDetails getSuperClass();

    public TypeDetails getGenericSuperType();

    public List<TypeDetails> getImplementedInterfaces();

    public List<TypeVariableDetails> getTypeParameters();

    default public void forEachSuper(ClassDetailsConsumer consumer) {
        for (ClassDetails check = this.getSuperClass(); check != null && check != OBJECT_CLASS_DETAILS; check = check.getSuperClass()) {
            consumer.accept(check);
        }
    }

    default public void forSelfAndEachSuper(ClassDetailsConsumer consumer) {
        consumer.accept(this);
        this.forEachSuper(consumer);
    }

    default public boolean isSuperclass(ClassDetails classDetails) {
        for (ClassDetails check = this.getSuperClass(); check != null && check != OBJECT_CLASS_DETAILS; check = check.getSuperClass()) {
            if (classDetails != check) continue;
            return true;
        }
        return false;
    }

    @Override
    default public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        TypeDetails genericSuperType;
        if (this == typeVariable.getDeclaringType()) {
            return TypeDetailsHelper.findTypeVariableDetails(typeVariable.getIdentifier(), this.getTypeParameters());
        }
        if (this.isSuperclass(typeVariable.getDeclaringType()) && (genericSuperType = this.getGenericSuperType()) != null) {
            return genericSuperType.resolveTypeVariable(typeVariable);
        }
        return null;
    }

    @Override
    default public ClassDetails determineRawClass() {
        return this;
    }

    public boolean isImplementor(Class<?> var1);

    public List<FieldDetails> getFields();

    public void forEachField(IndexedConsumer<FieldDetails> var1);

    default public FieldDetails findField(Predicate<FieldDetails> check) {
        List<FieldDetails> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDetails fieldDetails = fields.get(i);
            if (!check.test(fieldDetails)) continue;
            return fieldDetails;
        }
        return null;
    }

    default public FieldDetails findFieldByName(String name) {
        if (!1.$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.findField(fieldDetails -> name.equals(fieldDetails.getName()));
    }

    public List<MethodDetails> getMethods();

    public void forEachMethod(IndexedConsumer<MethodDetails> var1);

    public List<RecordComponentDetails> getRecordComponents();

    default public RecordComponentDetails findRecordComponent(Predicate<RecordComponentDetails> check) {
        List<RecordComponentDetails> components = this.getRecordComponents();
        for (int i = 0; i < components.size(); ++i) {
            RecordComponentDetails component = components.get(i);
            if (!check.test(component)) continue;
            return component;
        }
        return null;
    }

    default public RecordComponentDetails findRecordComponentByName(String name) {
        if (!1.$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.findRecordComponent(component -> name.equals(component.getName()));
    }

    public <X> Class<X> toJavaClass();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        OBJECT_CLASS_DETAILS = new SimpleClassDetails(Object.class);
        CLASS_CLASS_DETAILS = new SimpleClassDetails(Class.class);
        VOID_CLASS_DETAILS = new SimpleClassDetails(Void.TYPE);
        VOID_OBJECT_CLASS_DETAILS = new SimpleClassDetails(Void.class);
    }

    @FunctionalInterface
    public static interface ClassDetailsConsumer
    extends Consumer<ClassDetails> {
        @Override
        public void accept(ClassDetails var1);
    }
}

