/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.beans.Introspector;
import java.util.List;
import org.hibernate.models.internal.ModifierUtils;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;

public interface MethodDetails
extends MemberDetails {
    public MethodKind getMethodKind();

    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.METHOD;
    }

    public ClassDetails getReturnType();

    public List<ClassDetails> getArgumentTypes();

    @Override
    default public boolean isPersistable() {
        return this.getMethodKind() == MethodKind.GETTER && ModifierUtils.hasPersistableMethodModifiers(this.getModifiers());
    }

    @Override
    default public String resolveAttributeName() {
        String methodName = this.getName();
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public static enum MethodKind {
        GETTER,
        SETTER,
        OTHER;

    }
}

