/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.Locale;
import org.hibernate.models.internal.AttributeDescriptorImpl;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueTypeDescriptor;
import org.hibernate.models.spi.ValueWrapper;

public abstract class AbstractTypeDescriptor<V>
implements ValueTypeDescriptor<V> {
    @Override
    public AttributeDescriptor<V> createAttributeDescriptor(AnnotationDescriptor<?> annotationDescriptor, String attributeName) {
        return new AttributeDescriptorImpl(annotationDescriptor.getAnnotationType(), attributeName, this);
    }

    @Override
    public V createValue(AttributeDescriptor<?> attributeDescriptor, SourceModelBuildingContext context) {
        Object defaultValue = attributeDescriptor.getAttributeMethod().getDefaultValue();
        if (defaultValue == null) {
            return null;
        }
        ValueWrapper valueWrapper = this.createJdkWrapper(context);
        return valueWrapper.wrap(defaultValue, context);
    }

    @Override
    public void render(RenderingCollector collector, String name, Object attributeValue) {
        collector.addLine("%s = %s", name, attributeValue);
    }

    @Override
    public void render(RenderingCollector collector, Object attributeValue) {
        collector.addLine("%s = %s", attributeValue);
    }

    public String toString() {
        return String.format(Locale.ROOT, "AttributeTypeDescriptor(%s)", this.getWrappedValueType().getName());
    }
}

