/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.Map;
import org.hibernate.models.internal.AbstractAnnotationDescriptorRegistry;
import org.hibernate.models.internal.AnnotationDescriptorRegistryImmutable;
import org.hibernate.models.internal.ModelsAnnotationLogging;
import org.hibernate.models.internal.SourceModelBuildingContextImpl;
import org.hibernate.models.internal.jdk.AnnotationDescriptorImpl;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;

public class AnnotationDescriptorRegistryStandard
extends AbstractAnnotationDescriptorRegistry {
    private final SourceModelBuildingContextImpl modelBuildingContext;

    public AnnotationDescriptorRegistryStandard(SourceModelBuildingContextImpl modelBuildingContext) {
        this.modelBuildingContext = modelBuildingContext;
    }

    public void register(AnnotationDescriptor<?> descriptor) {
        ModelsAnnotationLogging.MODELS_ANNOTATION_LOGGER.tracef("Registering AnnotationDescriptor - %s", descriptor);
        this.descriptorMap.put(descriptor.getAnnotationType(), descriptor);
        if (descriptor.getRepeatableContainer() != null) {
            ModelsAnnotationLogging.MODELS_ANNOTATION_LOGGER.tracef("Registering repeatable AnnotationDescriptor - %s", descriptor.getRepeatableContainer());
            this.repeatableByContainerMap.put(descriptor.getRepeatableContainer(), descriptor);
        }
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> getDescriptor(Class<A> javaType) {
        return this.resolveDescriptor(javaType, this::buildAdHocAnnotationDescriptor);
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> resolveDescriptor(Class<A> javaType, AnnotationDescriptorRegistry.DescriptorCreator<A> creator) {
        AnnotationDescriptor existing = (AnnotationDescriptor)this.descriptorMap.get(javaType);
        if (existing != null) {
            return existing;
        }
        AnnotationDescriptor<A> created = creator.createDescriptor(javaType);
        this.descriptorMap.put(javaType, created);
        return created;
    }

    private <A extends Annotation> AnnotationDescriptor<A> buildAdHocAnnotationDescriptor(Class<A> javaType) {
        AnnotationDescriptor<? extends Annotation> containerDescriptor;
        Repeatable repeatable = javaType.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            containerDescriptor = this.getDescriptor(repeatable.value());
            assert (containerDescriptor != null);
        } else {
            containerDescriptor = null;
        }
        AnnotationDescriptorImpl<A> descriptor = new AnnotationDescriptorImpl<A>(javaType, containerDescriptor, this.modelBuildingContext);
        this.descriptorMap.put(javaType, descriptor);
        return descriptor;
    }

    @Override
    public AnnotationDescriptorRegistry makeImmutableCopy() {
        return new AnnotationDescriptorRegistryImmutable(Map.copyOf(this.descriptorMap), Map.copyOf(this.repeatableByContainerMap));
    }
}

