/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.models.AnnotationAccessException;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationUsage;

public class AnnotationUsageHelper {
    public static <A extends Annotation> AnnotationUsage<A> findUsage(AnnotationDescriptor<A> type, Map<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> usageMap) {
        return usageMap.get(type.getAnnotationType());
    }

    public static <A extends Annotation> AnnotationUsage<A> getUsage(AnnotationDescriptor<A> type, Map<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> usageMap) {
        AnnotationUsage<?> containerUsage;
        AnnotationDescriptor<?> repeatableContainer;
        AnnotationUsage<A> found = AnnotationUsageHelper.findUsage(type, usageMap);
        if (found == null && (repeatableContainer = type.getRepeatableContainer()) != null && (containerUsage = AnnotationUsageHelper.findUsage(repeatableContainer, usageMap)) != null) {
            List nestedUsages = (List)containerUsage.getAttributeValue("value");
            if (CollectionHelper.isEmpty(nestedUsages)) {
                return null;
            }
            if (nestedUsages.size() > 1) {
                throw new AnnotationAccessException("Found more than one usage of " + type.getAnnotationType().getName());
            }
            return (AnnotationUsage)nestedUsages.get(0);
        }
        return found;
    }

    public static <A extends Annotation> List<AnnotationUsage<A>> getRepeatedUsages(AnnotationDescriptor<A> type, Map<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> usageMap) {
        List repetitions;
        AnnotationUsage<?> containerUsage;
        AnnotationUsage<A> usage = AnnotationUsageHelper.findUsage(type, usageMap);
        AnnotationUsage<?> annotationUsage = containerUsage = type.getRepeatableContainer() != null ? AnnotationUsageHelper.findUsage(type.getRepeatableContainer(), usageMap) : null;
        if (containerUsage != null && CollectionHelper.isNotEmpty(repetitions = (List)containerUsage.getAttributeValue("value"))) {
            if (usage != null) {
                ArrayList<AnnotationUsage<A>> combined = new ArrayList<AnnotationUsage<A>>(repetitions);
                combined.add(0, usage);
                return combined;
            }
            return repetitions;
        }
        if (usage != null) {
            return Collections.singletonList(usage);
        }
        return Collections.emptyList();
    }

    public static <A extends Annotation> AnnotationUsage<A> getNamedUsage(AnnotationDescriptor<A> type, String matchValue, String attributeToMatch, Map<Class<? extends Annotation>, AnnotationUsage<?>> usageMap) {
        AnnotationUsage<?> containerUsage;
        AnnotationUsage<?> annotationUsage = usageMap.get(type.getAnnotationType());
        if (annotationUsage != null) {
            if (AnnotationUsageHelper.nameMatches(annotationUsage, matchValue, attributeToMatch)) {
                return annotationUsage;
            }
            return null;
        }
        AnnotationDescriptor<?> containerType = type.getRepeatableContainer();
        if (containerType != null && (containerUsage = usageMap.get(containerType.getAnnotationType())) != null) {
            List repeatedUsages = (List)containerUsage.getAttributeValue("value");
            for (int i = 0; i < repeatedUsages.size(); ++i) {
                AnnotationUsage repeatedUsage = (AnnotationUsage)repeatedUsages.get(i);
                if (!AnnotationUsageHelper.nameMatches(repeatedUsage, matchValue, attributeToMatch)) continue;
                return repeatedUsage;
            }
        }
        return null;
    }

    private static boolean nameMatches(AnnotationUsage<?> annotationUsage, String matchValue, String attributeToMatch) {
        String name = (String)annotationUsage.getAttributeValue(attributeToMatch);
        return matchValue.equals(name);
    }

    private AnnotationUsageHelper() {
    }
}

