/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.List;
import org.hibernate.models.internal.AttributeDescriptorImpl;
import org.hibernate.models.internal.jandex.ArrayValueWrapper;
import org.hibernate.models.internal.jdk.ArrayValueExtractor;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueExtractor;
import org.hibernate.models.spi.ValueTypeDescriptor;
import org.hibernate.models.spi.ValueWrapper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ArrayTypeDescriptor<V>
implements ValueTypeDescriptor<List<V>> {
    private final ValueTypeDescriptor<V> elementTypeDescriptor;
    private final Class<?> componentType;
    private ValueWrapper<List<V>, AnnotationValue> jandexValueWrapper;
    private ValueExtractor<AnnotationInstance, List<V>> jandexValueExtractor;
    private ValueWrapper<List<V>, Object[]> jdkValueWrapper;
    private ValueExtractor<Annotation, List<V>> jdkValueExtractor;

    public ArrayTypeDescriptor(ValueTypeDescriptor<V> elementTypeDescriptor, Class<?> componentType) {
        this.elementTypeDescriptor = elementTypeDescriptor;
        this.componentType = componentType;
    }

    @Override
    public Class<List<V>> getWrappedValueType() {
        return List.class;
    }

    @Override
    public List<V> createValue(AttributeDescriptor<?> attributeDescriptor, SourceModelBuildingContext context) {
        Object defaultValue = attributeDescriptor.getAttributeMethod().getDefaultValue();
        if (defaultValue == null) {
            return null;
        }
        ValueWrapper<List<V>, Object[]> jdkWrapper = this.createJdkWrapper(context);
        return jdkWrapper.wrap((Object[])defaultValue, context);
    }

    @Override
    public AttributeDescriptor<List<V>> createAttributeDescriptor(AnnotationDescriptor<?> annotationDescriptor, String attributeName) {
        return new AttributeDescriptorImpl<List<V>>(annotationDescriptor.getAnnotationType(), attributeName, this);
    }

    @Override
    public ValueExtractor<AnnotationInstance, List<V>> createJandexExtractor(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexExtractor(buildingContext);
    }

    public ValueExtractor<AnnotationInstance, List<V>> resolveJandexExtractor(SourceModelBuildingContext buildingContext) {
        if (this.jandexValueExtractor == null) {
            this.jandexValueExtractor = new org.hibernate.models.internal.jandex.ArrayValueExtractor<V>(this.resolveJandexWrapper(buildingContext));
        }
        return this.jandexValueExtractor;
    }

    @Override
    public ValueWrapper<List<V>, AnnotationValue> createJandexWrapper(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexWrapper(buildingContext);
    }

    private ValueWrapper<List<V>, AnnotationValue> resolveJandexWrapper(SourceModelBuildingContext buildingContext) {
        if (this.jandexValueWrapper == null) {
            ValueWrapper<V, AnnotationValue> jandexElementWrapper = this.elementTypeDescriptor.createJandexWrapper(buildingContext);
            this.jandexValueWrapper = new ArrayValueWrapper<V>(jandexElementWrapper);
        }
        return this.jandexValueWrapper;
    }

    @Override
    public ValueExtractor<Annotation, List<V>> createJdkExtractor(SourceModelBuildingContext buildingContext) {
        return this.resolveJdkExtractor(buildingContext);
    }

    public ValueExtractor<Annotation, List<V>> resolveJdkExtractor(SourceModelBuildingContext buildingContext) {
        if (this.jdkValueExtractor == null) {
            this.jdkValueExtractor = new ArrayValueExtractor(this.resolveJkWrapper(buildingContext));
        }
        return this.jdkValueExtractor;
    }

    @Override
    public ValueWrapper<List<V>, Object[]> createJdkWrapper(SourceModelBuildingContext buildingContext) {
        return this.resolveJkWrapper(buildingContext);
    }

    public ValueWrapper<List<V>, Object[]> resolveJkWrapper(SourceModelBuildingContext buildingContext) {
        if (this.jdkValueWrapper == null) {
            ValueWrapper<V, ?> jdkElementWrapper = this.elementTypeDescriptor.createJdkWrapper(buildingContext);
            this.jdkValueWrapper = new org.hibernate.models.internal.jdk.ArrayValueWrapper(jdkElementWrapper);
        }
        return this.jdkValueWrapper;
    }

    @Override
    public Object unwrap(List<V> value) {
        Object[] result = (Object[])Array.newInstance(this.componentType, value.size());
        for (int i = 0; i < value.size(); ++i) {
            result[i] = this.elementTypeDescriptor.unwrap(value.get(i));
        }
        return result;
    }

    @Override
    public void render(RenderingCollector collector, String name, Object attributeValue) {
        List values = (List)attributeValue;
        collector.addLine("%s = {", name);
        collector.indent(2);
        values.forEach(value -> this.elementTypeDescriptor.render(collector, value));
        collector.unindent(2);
        collector.addLine("}");
    }

    @Override
    public void render(RenderingCollector collector, Object attributeValue) {
        List values = (List)attributeValue;
        collector.addLine("{");
        collector.indent(2);
        values.forEach(value -> this.elementTypeDescriptor.render(collector, value));
        collector.unindent(2);
        collector.addLine("}");
    }
}

