/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.internal.AnnotationUsageHelper;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.internal.util.IndexedConsumer;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;

public interface ClassDetailsSupport
extends MutableClassDetails,
AnnotationTargetSupport {
    @Override
    default public void forEachField(IndexedConsumer<FieldDetails> consumer) {
        List<FieldDetails> fields = this.getFields();
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            consumer.accept(i, fields.get(i));
        }
    }

    @Override
    default public void forEachMethod(IndexedConsumer<MethodDetails> consumer) {
        List<MethodDetails> methods = this.getMethods();
        if (methods == null) {
            return;
        }
        for (int i = 0; i < methods.size(); ++i) {
            consumer.accept(i, methods.get(i));
        }
    }

    @Override
    default public <A extends Annotation> AnnotationUsage<A> getAnnotationUsage(AnnotationDescriptor<A> type) {
        AnnotationUsage<A> localUsage = AnnotationUsageHelper.getUsage(type, this.getUsageMap());
        if (localUsage != null) {
            return localUsage;
        }
        if (type.isInherited() && this.getSuperClass() != null) {
            return this.getSuperClass().getAnnotationUsage(type);
        }
        return null;
    }

    @Override
    default public <A extends Annotation> List<AnnotationUsage<A>> getRepeatedAnnotationUsages(AnnotationDescriptor<A> type) {
        List<AnnotationUsage<A>> localUsages = AnnotationTargetSupport.super.getRepeatedAnnotationUsages(type);
        if (type.isInherited() && this.getSuperClass() != null) {
            List<AnnotationUsage<A>> inheritedUsages = this.getSuperClass().getRepeatedAnnotationUsages(type);
            return CollectionHelper.join(localUsages, inheritedUsages);
        }
        return localUsages;
    }

    default public <A extends Annotation> AnnotationUsage<A> getNamedAnnotationUsage(AnnotationDescriptor<A> type, String matchValue, String attributeToMatch) {
        AnnotationUsage<A> localUsage = AnnotationTargetSupport.super.getNamedAnnotationUsage(type, matchValue, attributeToMatch);
        if (localUsage != null) {
            return localUsage;
        }
        if (type.isInherited() && this.getSuperClass() != null) {
            return this.getSuperClass().getNamedAnnotationUsage(type, matchValue, attributeToMatch);
        }
        return null;
    }
}

