/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.internal.jandex.EnumValueExtractor;
import org.hibernate.models.internal.jandex.EnumValueWrapper;
import org.hibernate.models.internal.jdk.PassThruExtractor;
import org.hibernate.models.internal.jdk.PassThruWrapper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueExtractor;
import org.hibernate.models.spi.ValueWrapper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class EnumTypeDescriptor<E extends Enum<E>>
extends AbstractTypeDescriptor<E> {
    private final Class<E> enumType;
    private final EnumValueWrapper<E> jandexWrapper;
    private final EnumValueExtractor<E> jandexExtractor;

    public EnumTypeDescriptor(Class<E> enumType) {
        this.enumType = enumType;
        this.jandexWrapper = new EnumValueWrapper<E>(enumType);
        this.jandexExtractor = new EnumValueExtractor<E>(this.jandexWrapper);
    }

    @Override
    public Class<E> getWrappedValueType() {
        return this.enumType;
    }

    @Override
    public ValueWrapper<E, AnnotationValue> createJandexWrapper(SourceModelBuildingContext buildingContext) {
        return this.jandexWrapper;
    }

    @Override
    public ValueExtractor<AnnotationInstance, E> createJandexExtractor(SourceModelBuildingContext buildingContext) {
        return this.jandexExtractor;
    }

    @Override
    public ValueWrapper<E, ?> createJdkWrapper(SourceModelBuildingContext buildingContext) {
        return PassThruWrapper.PASS_THRU_WRAPPER;
    }

    @Override
    public ValueExtractor<Annotation, E> createJdkExtractor(SourceModelBuildingContext buildingContext) {
        return PassThruExtractor.PASS_THRU_EXTRACTOR;
    }

    @Override
    public Object unwrap(E value) {
        return value;
    }
}

