/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.internal.jandex.StringValueExtractor;
import org.hibernate.models.internal.jandex.StringValueWrapper;
import org.hibernate.models.internal.jdk.PassThruExtractor;
import org.hibernate.models.internal.jdk.PassThruWrapper;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueExtractor;
import org.hibernate.models.spi.ValueWrapper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class StringTypeDescriptor
extends AbstractTypeDescriptor<String> {
    public static final StringTypeDescriptor STRING_TYPE_DESCRIPTOR = new StringTypeDescriptor();

    @Override
    public Class<String> getWrappedValueType() {
        return String.class;
    }

    @Override
    public ValueWrapper<String, AnnotationValue> createJandexWrapper(SourceModelBuildingContext buildingContext) {
        return StringValueWrapper.JANDEX_STRING_VALUE_WRAPPER;
    }

    @Override
    public ValueExtractor<AnnotationInstance, String> createJandexExtractor(SourceModelBuildingContext buildingContext) {
        return StringValueExtractor.JANDEX_STRING_EXTRACTOR;
    }

    @Override
    public ValueWrapper<String, ?> createJdkWrapper(SourceModelBuildingContext buildingContext) {
        return PassThruWrapper.PASS_THRU_WRAPPER;
    }

    @Override
    public ValueExtractor<Annotation, String> createJdkExtractor(SourceModelBuildingContext buildingContext) {
        return PassThruExtractor.PASS_THRU_EXTRACTOR;
    }

    @Override
    public Object unwrap(String value) {
        return value;
    }

    @Override
    public void render(RenderingCollector collector, String name, Object attributeValue) {
        super.render(collector, name, "\"" + attributeValue + "\"");
    }

    @Override
    public void render(RenderingCollector collector, Object attributeValue) {
        super.render(collector, attributeValue);
    }
}

