/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.dynamic;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;

public abstract class AbstractAnnotationTarget
implements AnnotationTargetSupport {
    private final SourceModelBuildingContext buildingContext;
    private final Map<Class<? extends Annotation>, AnnotationUsage<?>> usageMap = new HashMap();

    public AbstractAnnotationTarget(SourceModelBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    @Override
    public SourceModelBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    @Override
    public Map<Class<? extends Annotation>, AnnotationUsage<? extends Annotation>> getUsageMap() {
        return this.usageMap;
    }

    @Override
    public void clearAnnotationUsages() {
        this.usageMap.clear();
    }

    @Override
    public <X extends Annotation> void addAnnotationUsage(AnnotationUsage<X> annotationUsage) {
        assert (annotationUsage.getAnnotationDescriptor().getAllowableTargets().contains((Object)this.getKind()));
        AnnotationUsage<X> previous = this.usageMap.put(annotationUsage.getAnnotationType(), annotationUsage);
        if (previous != null) {
            // empty if block
        }
    }
}

