/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.dynamic;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.models.internal.AnnotationProxy;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class DynamicAnnotationUsage<A extends Annotation>
implements MutableAnnotationUsage<A> {
    private final AnnotationDescriptor<A> annotationDescriptor;
    private Map<String, Object> values;

    public DynamicAnnotationUsage(AnnotationDescriptor<A> annotationDescriptor, SourceModelBuildingContext context) {
        this(annotationDescriptor, DynamicAnnotationUsage.extractBaselineValues(annotationDescriptor, context));
    }

    private DynamicAnnotationUsage(AnnotationDescriptor<A> annotationDescriptor, Map<String, Object> values) {
        this.annotationDescriptor = annotationDescriptor;
        this.values = values;
    }

    @Override
    public AnnotationDescriptor<A> getAnnotationDescriptor() {
        return this.annotationDescriptor;
    }

    @Override
    public A toAnnotation() {
        return AnnotationProxy.makeProxy(this.annotationDescriptor, this.values);
    }

    @Override
    public <V> V findAttributeValue(String name) {
        if (this.values != null) {
            return (V)this.values.get(name);
        }
        return null;
    }

    @Override
    public <V> V getAttributeValue(String name) {
        AttributeDescriptor attribute = this.annotationDescriptor.getAttribute(name);
        return this.findAttributeValue(attribute.getName());
    }

    @Override
    public <V> V setAttributeValue(String name, V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Null value not allowed for attribute `%s` of annotation `%s`", name, this.getAnnotationType().getName()));
        }
        AttributeDescriptor attribute = this.annotationDescriptor.getAttribute(name);
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        return (V)this.values.put(attribute.getName(), value);
    }

    private static <A extends Annotation> Map<String, Object> extractBaselineValues(AnnotationDescriptor<A> annotationDescriptor, SourceModelBuildingContext context) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (AttributeDescriptor<?> attribute : annotationDescriptor.getAttributes()) {
            values.put(attribute.getName(), attribute.getTypeDescriptor().createValue(attribute, context));
        }
        return values;
    }
}

