/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.dynamic;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.models.internal.dynamic.AbstractAnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class DynamicMethodDetails
extends AbstractAnnotationTarget
implements MethodDetails,
MutableMemberDetails {
    private final String name;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final MethodDetails.MethodKind methodKind;
    private final int modifierFlags;
    private final ClassDetails returnType;
    private final List<ClassDetails> argumentTypes;
    private final boolean isArray;
    private final boolean isPlural;

    public DynamicMethodDetails(String name, TypeDetails type, ClassDetails declaringType, MethodDetails.MethodKind methodKind, int modifierFlags, ClassDetails returnType, List<ClassDetails> argumentTypes, SourceModelBuildingContext buildingContext) {
        this(name, type, declaringType, methodKind, modifierFlags, type != null && type.getName().startsWith("["), type != null && (type.isImplementor(Collection.class) || type.isImplementor(Map.class)), returnType, argumentTypes, buildingContext);
    }

    public DynamicMethodDetails(String name, TypeDetails type, ClassDetails declaringType, MethodDetails.MethodKind methodKind, int modifierFlags, boolean isArray, boolean isPlural, ClassDetails returnType, List<ClassDetails> argumentTypes, SourceModelBuildingContext buildingContext) {
        super(buildingContext);
        this.name = name;
        this.type = type;
        this.declaringType = declaringType;
        this.methodKind = methodKind;
        this.modifierFlags = modifierFlags;
        this.isArray = isArray;
        this.isPlural = isPlural;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MethodDetails.MethodKind getMethodKind() {
        return this.methodKind;
    }

    @Override
    public TypeDetails getType() {
        return this.type;
    }

    @Override
    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isPlural() {
        return this.isPlural;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public int getModifiers() {
        return this.modifierFlags;
    }

    @Override
    public Member toJavaMember() {
        return null;
    }

    @Override
    public TypeDetails resolveRelativeType(TypeVariableScope container) {
        return this.type;
    }

    @Override
    public ClassDetails getReturnType() {
        return this.returnType;
    }

    @Override
    public List<ClassDetails> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String toString() {
        return "DynamicMethodDetails(" + this.name + ")";
    }
}

