/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.internal.jandex.AnnotationUsageBuilder;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationTarget;

public abstract class AbstractAnnotationTarget
implements AnnotationTargetSupport {
    private final SourceModelBuildingContext buildingContext;
    private Map<Class<? extends Annotation>, AnnotationUsage<?>> usageMap;

    public AbstractAnnotationTarget(SourceModelBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    protected abstract AnnotationTarget getJandexAnnotationTarget();

    public Map<Class<? extends Annotation>, AnnotationUsage<?>> getUsageMap() {
        if (this.usageMap == null) {
            this.usageMap = AnnotationUsageBuilder.collectUsages(this.getJandexAnnotationTarget(), this.buildingContext);
        }
        return this.usageMap;
    }

    @Override
    public void clearAnnotationUsages() {
        this.getUsageMap().clear();
    }

    @Override
    public <X extends Annotation> void addAnnotationUsage(AnnotationUsage<X> annotationUsage) {
        assert (annotationUsage.getAnnotationDescriptor().getAllowableTargets().contains((Object)this.getKind()));
        this.getUsageMap().put(annotationUsage.getAnnotationType(), annotationUsage);
    }

    @Override
    public SourceModelBuildingContext getBuildingContext() {
        return this.buildingContext;
    }
}

