/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.util.List;
import org.hibernate.models.internal.jandex.AbstractValueExtractor;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueWrapper;
import org.jboss.jandex.AnnotationValue;

public class ArrayValueExtractor<V>
extends AbstractValueExtractor<List<V>> {
    private final ValueWrapper<List<V>, AnnotationValue> wrapper;

    public ArrayValueExtractor(ValueWrapper<List<V>, AnnotationValue> wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    protected List<V> extractAndWrap(AnnotationValue jandexValue, SourceModelBuildingContext buildingContext) {
        assert (jandexValue != null);
        List values = jandexValue.asArrayList();
        assert (values != null);
        return this.wrapper.wrap(jandexValue, buildingContext);
    }
}

