/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueWrapper;
import org.jboss.jandex.AnnotationValue;

public class ArrayValueWrapper<V>
implements ValueWrapper<List<V>, AnnotationValue> {
    private final ValueWrapper<V, AnnotationValue> elementWrapper;

    public ArrayValueWrapper(ValueWrapper<V, AnnotationValue> elementWrapper) {
        this.elementWrapper = elementWrapper;
    }

    @Override
    public List<V> wrap(AnnotationValue rawValue, SourceModelBuildingContext buildingContext) {
        assert (rawValue != null);
        List values = rawValue.asArrayList();
        assert (values != null);
        ArrayList<V> result = new ArrayList<V>(values.size());
        for (AnnotationValue value : values) {
            result.add(this.elementWrapper.wrap(value, buildingContext));
        }
        return result;
    }
}

