/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.models.internal.AnnotationProxy;
import org.hibernate.models.internal.jandex.AnnotationUsageBuilder;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class JandexAnnotationUsage<A extends Annotation>
implements MutableAnnotationUsage<A> {
    private final AnnotationDescriptor<A> annotationDescriptor;
    private final Map<String, ?> attributeValueMap;

    public JandexAnnotationUsage(AnnotationInstance annotationInstance, AnnotationDescriptor<A> annotationDescriptor, SourceModelBuildingContext processingContext) {
        assert (annotationInstance != null) : "Jandex AnnotationInstance was null";
        assert (annotationDescriptor != null) : "AnnotationDescriptor was null - " + annotationInstance;
        this.annotationDescriptor = annotationDescriptor;
        this.attributeValueMap = AnnotationUsageBuilder.extractAttributeValues(annotationInstance, annotationDescriptor, processingContext);
    }

    @Override
    public AnnotationDescriptor<A> getAnnotationDescriptor() {
        return this.annotationDescriptor;
    }

    @Override
    public A toAnnotation() {
        return AnnotationProxy.makeProxy(this.annotationDescriptor, this.attributeValueMap);
    }

    @Override
    public <W> W findAttributeValue(String name) {
        return (W)this.attributeValueMap.get(name);
    }

    @Override
    public <V> V setAttributeValue(String name, V value) {
        this.annotationDescriptor.getAttribute(name);
        return (V)this.attributeValueMap.put(name, value);
    }

    public String toString() {
        return "JandexAnnotationUsage(" + this.annotationDescriptor.getAnnotationType().getName() + ")";
    }
}

