/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.internal.ClassDetailsSupport;
import org.hibernate.models.internal.ModelsClassLogging;
import org.hibernate.models.internal.jandex.AbstractAnnotationTarget;
import org.hibernate.models.internal.jandex.JandexBuilders;
import org.hibernate.models.internal.jandex.JandexFieldDetails;
import org.hibernate.models.internal.jandex.JandexRecordComponentDetails;
import org.hibernate.models.internal.jandex.JandexTypeSwitchStandard;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class JandexClassDetails
extends AbstractAnnotationTarget
implements ClassDetailsSupport {
    private final ClassInfo classInfo;
    private final ClassDetails superClass;
    private TypeDetails genericSuperType;
    private final List<TypeDetails> implementedInterfaces;
    private List<TypeVariableDetails> typeParameters;
    private List<FieldDetails> fields;
    private List<MethodDetails> methods;
    private List<RecordComponentDetails> recordComponents;
    private Class<?> javaClass;

    public JandexClassDetails(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        super(buildingContext);
        this.classInfo = classInfo;
        this.superClass = JandexClassDetails.determineSuperType(classInfo, buildingContext);
        this.implementedInterfaces = JandexClassDetails.determineInterfaces(classInfo, buildingContext);
    }

    private static ClassDetails determineSuperType(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        if (classInfo.superClassType() == null) {
            return null;
        }
        return buildingContext.getClassDetailsRegistry().resolveClassDetails(classInfo.superClassType().name().toString());
    }

    private TypeDetails determineGenericSuperType(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        if (classInfo.superClassType() == null) {
            return null;
        }
        return JandexTypeSwitchStandard.switchType(classInfo.superClassType(), buildingContext);
    }

    private static List<TypeDetails> determineInterfaces(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        List interfaceTypes = classInfo.interfaceTypes();
        if (CollectionHelper.isEmpty(interfaceTypes)) {
            return Collections.emptyList();
        }
        ArrayList<TypeDetails> result = CollectionHelper.arrayList(interfaceTypes.size());
        for (Type interfaceType : interfaceTypes) {
            TypeDetails switchedType = JandexTypeSwitchStandard.switchType(interfaceType, buildingContext);
            result.add(switchedType);
        }
        return result;
    }

    private List<TypeVariableDetails> determineTypeParameters(ClassInfo classInfo, SourceModelBuildingContext buildingContext) {
        List jandexTypeVariables = classInfo.typeParameters();
        if (CollectionHelper.isEmpty(jandexTypeVariables)) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariableDetails> result = CollectionHelper.arrayList(jandexTypeVariables.size());
        for (TypeVariable jandexTypeVariable : jandexTypeVariables) {
            result.add((TypeVariableDetails)JandexTypeSwitchStandard.switchType((Type)jandexTypeVariable, this, buildingContext));
        }
        return result;
    }

    @Override
    protected AnnotationTarget getJandexAnnotationTarget() {
        return this.classInfo;
    }

    @Override
    public String getName() {
        return this.getClassName();
    }

    @Override
    public String getClassName() {
        return this.classInfo.name().toString();
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.classInfo.flags());
    }

    @Override
    public boolean isRecord() {
        return this.classInfo.isRecord();
    }

    @Override
    public ClassDetails getSuperClass() {
        return this.superClass;
    }

    @Override
    public TypeDetails getGenericSuperType() {
        if (this.genericSuperType == null && this.classInfo.superClassType() != null) {
            this.genericSuperType = this.determineGenericSuperType(this.classInfo, this.getBuildingContext());
        }
        return this.genericSuperType;
    }

    @Override
    public List<TypeDetails> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    @Override
    public List<TypeVariableDetails> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = this.determineTypeParameters(this.classInfo, this.getBuildingContext());
        }
        return this.typeParameters;
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        if (this.getClassName().equals(checkType.getName())) {
            return true;
        }
        if (this.superClass != null && this.superClass.isImplementor(checkType)) {
            return true;
        }
        for (TypeDetails intf : this.implementedInterfaces) {
            if (!intf.isImplementor(checkType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FieldDetails> getFields() {
        if (this.fields == null) {
            this.fields = this.resolveFields();
        }
        return this.fields;
    }

    private List<FieldDetails> resolveFields() {
        List fieldsInfoList = this.classInfo.fields();
        ArrayList<FieldDetails> result = new ArrayList<FieldDetails>(fieldsInfoList.size());
        for (FieldInfo fieldInfo : fieldsInfoList) {
            result.add(new JandexFieldDetails(fieldInfo, this, this.getBuildingContext()));
        }
        return result;
    }

    @Override
    public void addField(FieldDetails fieldDetails) {
        this.getFields().add(fieldDetails);
    }

    @Override
    public List<RecordComponentDetails> getRecordComponents() {
        if (this.recordComponents == null) {
            this.recordComponents = this.resolveRecordComponents();
        }
        return this.recordComponents;
    }

    private List<RecordComponentDetails> resolveRecordComponents() {
        List componentInfoList = this.classInfo.recordComponents();
        ArrayList<RecordComponentDetails> result = CollectionHelper.arrayList(componentInfoList.size());
        for (RecordComponentInfo componentInfo : componentInfoList) {
            result.add(new JandexRecordComponentDetails(componentInfo, this, this.getBuildingContext()));
        }
        return result;
    }

    @Override
    public List<MethodDetails> getMethods() {
        if (this.methods == null) {
            this.methods = this.resolveMethods();
        }
        return this.methods;
    }

    private List<MethodDetails> resolveMethods() {
        List methodInfoList = this.classInfo.methods();
        ArrayList<MethodDetails> result = new ArrayList<MethodDetails>(methodInfoList.size());
        for (MethodInfo methodInfo : methodInfoList) {
            if (methodInfo.isConstructor() || "<clinit>".equals(methodInfo.name())) continue;
            result.add(JandexBuilders.buildMethodDetails(methodInfo, this, this.getBuildingContext()));
        }
        return result;
    }

    @Override
    public void addMethod(MethodDetails methodDetails) {
        this.getMethods().add(methodDetails);
    }

    @Override
    public <X> Class<X> toJavaClass() {
        if (this.javaClass == null) {
            if (this.getClassName() == null) {
                throw new UnsupportedOperationException("Not supported");
            }
            ModelsClassLogging.MODELS_CLASS_LOGGER.debugf("Loading `%s` on to classloader from Jandex ClassDetails", (Object)this.getClassName());
            this.javaClass = this.getBuildingContext().getClassLoading().classForName(this.getClassName());
        }
        return this.javaClass;
    }

    public String toString() {
        return "JandexClassDetails(" + this.classInfo.name().toString() + ")";
    }
}

