/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.hibernate.models.AnnotationAccessException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueExtractor;

public abstract class AbstractValueExtractor<W, R>
implements ValueExtractor<Annotation, W> {
    protected abstract W wrap(R var1, AttributeDescriptor<W> var2, SourceModelBuildingContext var3);

    @Override
    public W extractValue(Annotation annotation, String attributeName, SourceModelBuildingContext buildingContext) {
        AnnotationDescriptor<? extends Annotation> annDescriptor = buildingContext.getAnnotationDescriptorRegistry().getDescriptor(annotation.annotationType());
        return (W)this.extractValue(annotation, annDescriptor.getAttribute(attributeName), buildingContext);
    }

    @Override
    public W extractValue(Annotation annotation, AttributeDescriptor<W> attributeDescriptor, SourceModelBuildingContext buildingContext) {
        try {
            Object rawValue = attributeDescriptor.getAttributeMethod().invoke((Object)annotation, new Object[0]);
            return this.wrap(rawValue, attributeDescriptor, buildingContext);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationAccessException(String.format(Locale.ROOT, "Unable to extract attribute value [%s] from annotation [%s]", attributeDescriptor.getName(), annotation), e);
        }
    }
}

