/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.AttributeDescriptor;

public class AnnotationDescriptorOrmImpl<A extends Annotation>
implements AnnotationDescriptor<A> {
    private final Class<A> annotationType;
    private final EnumSet<AnnotationTarget.Kind> allowableTargets;
    private final boolean inherited;
    private final AnnotationDescriptor<?> repeatableContainer;
    private final List<AttributeDescriptor<?>> attributeDescriptors;

    public AnnotationDescriptorOrmImpl(Class<A> annotationType, AnnotationDescriptor<?> repeatableContainer) {
        this.annotationType = annotationType;
        this.repeatableContainer = repeatableContainer;
        this.inherited = AnnotationHelper.isInherited(annotationType);
        this.allowableTargets = AnnotationHelper.extractTargets(annotationType);
        this.attributeDescriptors = JdkBuilders.extractAttributeDescriptors(this, annotationType);
    }

    @Override
    public Class<A> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public EnumSet<AnnotationTarget.Kind> getAllowableTargets() {
        return this.allowableTargets;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    @Override
    public AnnotationDescriptor<?> getRepeatableContainer() {
        return this.repeatableContainer;
    }

    @Override
    public List<AttributeDescriptor<?>> getAttributes() {
        return this.attributeDescriptors;
    }

    @Override
    public String getName() {
        return this.annotationType.getName();
    }

    @Override
    public Collection<AnnotationUsage<?>> getAllAnnotationUsages() {
        return Collections.emptyList();
    }

    public <X extends Annotation> boolean hasAnnotationUsage(Class<X> type) {
        return false;
    }

    @Override
    public <A extends Annotation> boolean hasRepeatableAnnotationUsage(Class<A> type) {
        return false;
    }

    public <X extends Annotation> AnnotationUsage<X> getAnnotationUsage(AnnotationDescriptor<X> descriptor) {
        return null;
    }

    public <X extends Annotation> AnnotationUsage<X> getAnnotationUsage(Class<X> type) {
        return null;
    }

    public <X extends Annotation> AnnotationUsage<X> locateAnnotationUsage(Class<X> type) {
        return null;
    }

    public <X extends Annotation> List<AnnotationUsage<X>> getRepeatedAnnotationUsages(AnnotationDescriptor<X> type) {
        return null;
    }

    public <X extends Annotation> List<AnnotationUsage<X>> getRepeatedAnnotationUsages(Class<X> type) {
        return null;
    }

    @Override
    public <X extends Annotation> void forEachAnnotationUsage(AnnotationDescriptor<X> type, Consumer<AnnotationUsage<X>> consumer) {
    }

    @Override
    public <X extends Annotation> void forEachAnnotationUsage(Class<X> type, Consumer<AnnotationUsage<X>> consumer) {
    }

    public <X extends Annotation> List<AnnotationUsage<? extends Annotation>> getMetaAnnotated(Class<X> metaAnnotationType) {
        return Collections.emptyList();
    }

    @Override
    public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(AnnotationDescriptor<X> type, String matchName, String attributeToMatch) {
        return null;
    }

    @Override
    public <X extends Annotation> AnnotationUsage<X> getNamedAnnotationUsage(Class<X> type, String matchName, String attributeToMatch) {
        return null;
    }

    public String toString() {
        return "AnnotationDescriptor(" + this.annotationType + ")";
    }
}

