/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hibernate.models.internal.jdk.JdkAnnotationUsage;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueExtractor;

public class AnnotationUsageBuilder {
    public static void processAnnotations(Annotation[] annotations, BiConsumer<Class<? extends Annotation>, AnnotationUsage<?>> consumer, SourceModelBuildingContext buildingContext) {
        AnnotationDescriptorRegistry annotationDescriptorRegistry = buildingContext.getAnnotationDescriptorRegistry();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == Repeatable.class || annotationType == Target.class || annotationType == Retention.class || annotationType == Documented.class) continue;
            AnnotationDescriptor<? extends Annotation> annotationDescriptor = annotationDescriptorRegistry.getDescriptor(annotationType);
            AnnotationUsage<? extends Annotation> usage = AnnotationUsageBuilder.makeUsage(annotation, annotationDescriptor, buildingContext);
            consumer.accept(annotationType, usage);
        }
    }

    public static <A extends Annotation> AnnotationUsage<A> makeUsage(A annotation, AnnotationDescriptor<A> annotationDescriptor, SourceModelBuildingContext buildingContext) {
        return new JdkAnnotationUsage<A>(annotation, annotationDescriptor, buildingContext);
    }

    public static <A extends Annotation> Map<String, ?> extractAttributeValues(A annotation, AnnotationDescriptor<A> annotationDescriptor, SourceModelBuildingContext buildingContext) {
        if (CollectionHelper.isEmpty(annotationDescriptor.getAttributes())) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap valueMap = new ConcurrentHashMap();
        for (int i = 0; i < annotationDescriptor.getAttributes().size(); ++i) {
            AttributeDescriptor<?> attributeDescriptor = annotationDescriptor.getAttributes().get(i);
            ValueExtractor<Annotation, ?> valueExtractor = attributeDescriptor.getTypeDescriptor().createJdkExtractor(buildingContext);
            Object value = valueExtractor.extractValue(annotation, attributeDescriptor, buildingContext);
            valueMap.put(attributeDescriptor.getName(), value);
        }
        return valueMap;
    }

    private AnnotationUsageBuilder() {
    }
}

