/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.List;
import org.hibernate.models.internal.RenderingCollectorImpl;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.RenderingCollector;

public interface AnnotationUsage<A extends Annotation> {
    public AnnotationDescriptor<A> getAnnotationDescriptor();

    default public Class<A> getAnnotationType() {
        return this.getAnnotationDescriptor().getAnnotationType();
    }

    public A toAnnotation();

    public <V> V findAttributeValue(String var1);

    default public <V> V getAttributeValue(String name) {
        V value = this.findAttributeValue(name);
        if (value == null) {
            this.getAnnotationDescriptor().getAttribute(name);
        }
        return value;
    }

    default public <V> V getAttributeValue(AttributeDescriptor<V> attributeDescriptor) {
        return this.getAttributeValue(attributeDescriptor.getName());
    }

    default public String getString(String name) {
        return (String)this.getAttributeValue(name);
    }

    default public Boolean getBoolean(String name) {
        return (Boolean)this.getAttributeValue(name);
    }

    default public Byte getByte(String name) {
        return (Byte)this.getAttributeValue(name);
    }

    default public Short getShort(String name) {
        return (Short)this.getAttributeValue(name);
    }

    default public Integer getInteger(String name) {
        return (Integer)this.getAttributeValue(name);
    }

    default public Long getLong(String name) {
        return (Long)this.getAttributeValue(name);
    }

    default public Float getFloat(String name) {
        return (Float)this.getAttributeValue(name);
    }

    default public Double getDouble(String name) {
        return (Double)this.getAttributeValue(name);
    }

    default public <E extends Enum<E>> E getEnum(String name) {
        return (E)((Enum)this.getAttributeValue(name));
    }

    default public <E extends Enum<E>> E getEnum(String name, Class<E> type) {
        return (E)((Enum)this.getAttributeValue(name));
    }

    default public ClassDetails getClassDetails(String name) {
        return (ClassDetails)this.getAttributeValue(name);
    }

    default public <X extends Annotation> AnnotationUsage<X> getNestedUsage(String name) {
        return (AnnotationUsage)this.getAttributeValue(name);
    }

    default public <E> List<E> getList(String name) {
        return (List)this.getAttributeValue(name);
    }

    default public void render() {
        RenderingCollectorImpl renderingCollector = new RenderingCollectorImpl();
        this.render(renderingCollector);
        renderingCollector.render();
    }

    default public void render(RenderingCollector collector) {
        List<AttributeDescriptor<?>> attributes = this.getAnnotationDescriptor().getAttributes();
        if (attributes.isEmpty()) {
            collector.addLine("@%s", this.getAnnotationType().getName());
        } else {
            collector.addLine("@%s(", this.getAnnotationType().getName());
            collector.indent(2);
            attributes.forEach(attribute -> attribute.getTypeDescriptor().render(collector, attribute.getName(), this.getAttributeValue(attribute.getName())));
            collector.unindent(2);
            collector.addLine(")");
        }
    }

    default public void renderAttributeValue(String name, RenderingCollector collector) {
        List<AttributeDescriptor<?>> attributes = this.getAnnotationDescriptor().getAttributes();
        if (attributes.isEmpty()) {
            collector.addLine("%s = @%s", name, this.getAnnotationType().getName());
        } else {
            collector.addLine("%s = @%s(", name, this.getAnnotationType().getName());
            collector.indent(2);
            attributes.forEach(attribute -> attribute.getTypeDescriptor().render(collector, attribute.getName(), this.getAttributeValue(attribute.getName())));
            collector.unindent(2);
            collector.addLine(")");
        }
    }
}

