/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.RenderingCollectorImpl;
import org.hibernate.models.internal.SimpleClassDetails;
import org.hibernate.models.internal.util.IndexedConsumer;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableScope;

public interface ClassDetails
extends AnnotationTarget,
TypeVariableScope {
    public static final ClassDetails OBJECT_CLASS_DETAILS;
    public static final ClassDetails CLASS_CLASS_DETAILS;
    public static final ClassDetails VOID_CLASS_DETAILS;
    public static final ClassDetails VOID_OBJECT_CLASS_DETAILS;

    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.CLASS;
    }

    @Override
    public String getName();

    public String getClassName();

    public boolean isResolved();

    public boolean isAbstract();

    public boolean isRecord();

    public ClassDetails getSuperClass();

    public TypeDetails getGenericSuperType();

    public List<TypeDetails> getImplementedInterfaces();

    public List<TypeVariableDetails> getTypeParameters();

    default public void forEachSuper(ClassDetailsConsumer consumer) {
        for (ClassDetails check = this.getSuperClass(); check != null && check != OBJECT_CLASS_DETAILS; check = check.getSuperClass()) {
            consumer.accept(check);
        }
    }

    default public void forSelfAndEachSuper(ClassDetailsConsumer consumer) {
        consumer.accept(this);
        this.forEachSuper(consumer);
    }

    default public boolean isSuperclass(ClassDetails classDetails) {
        for (ClassDetails check = this.getSuperClass(); check != null && check != OBJECT_CLASS_DETAILS; check = check.getSuperClass()) {
            if (classDetails != check) continue;
            return true;
        }
        return false;
    }

    @Override
    default public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        TypeDetails genericSuperType;
        if (this == typeVariable.getDeclaringType()) {
            return TypeDetailsHelper.findTypeVariableDetails(typeVariable.getIdentifier(), this.getTypeParameters());
        }
        if (this.isSuperclass(typeVariable.getDeclaringType()) && (genericSuperType = this.getGenericSuperType()) != null) {
            return genericSuperType.resolveTypeVariable(typeVariable);
        }
        return null;
    }

    @Override
    default public ClassDetails determineRawClass() {
        return this;
    }

    public boolean isImplementor(Class<?> var1);

    public List<FieldDetails> getFields();

    public void forEachField(IndexedConsumer<FieldDetails> var1);

    default public FieldDetails findField(Predicate<FieldDetails> check) {
        List<FieldDetails> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDetails fieldDetails = fields.get(i);
            if (!check.test(fieldDetails)) continue;
            return fieldDetails;
        }
        return null;
    }

    default public FieldDetails findFieldByName(String name) {
        if (!1.$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.findField(fieldDetails -> name.equals(fieldDetails.getName()));
    }

    public List<MethodDetails> getMethods();

    public void forEachMethod(IndexedConsumer<MethodDetails> var1);

    public List<RecordComponentDetails> getRecordComponents();

    default public RecordComponentDetails findRecordComponent(Predicate<RecordComponentDetails> check) {
        List<RecordComponentDetails> components = this.getRecordComponents();
        for (int i = 0; i < components.size(); ++i) {
            RecordComponentDetails component = components.get(i);
            if (!check.test(component)) continue;
            return component;
        }
        return null;
    }

    default public RecordComponentDetails findRecordComponentByName(String name) {
        if (!1.$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.findRecordComponent(component -> name.equals(component.getName()));
    }

    public <X> Class<X> toJavaClass();

    @Override
    default public ClassDetails asClassDetails() {
        return this;
    }

    @Override
    default public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("ClassDetails cannot be cast to AnnotationDescriptor");
    }

    @Override
    default public MemberDetails asMemberDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to MemberDescriptor");
    }

    @Override
    default public FieldDetails asFieldDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to FieldDetails");
    }

    @Override
    default public MethodDetails asMethodDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to MethodDetails");
    }

    @Override
    default public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to RecordComponentDetails");
    }

    @Override
    default public void render() {
        RenderingCollectorImpl renderingCollector = new RenderingCollectorImpl();
        this.render(renderingCollector);
        renderingCollector.render();
    }

    @Override
    default public void render(RenderingCollector collector) {
        this.getAllAnnotationUsages().forEach(usage -> usage.render(collector));
        String pattern = this.isRecord() ? "record %s {" : "class %s {";
        collector.addLine(pattern, this.getName());
        collector.indent(1);
        collector.addLine("// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        collector.addLine("// fields");
        this.getFields().forEach(fieldDetails -> {
            fieldDetails.render(collector);
            collector.addLine();
        });
        collector.addLine();
        collector.addLine("// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        collector.addLine("// methods");
        this.getMethods().forEach(methodDetails -> {
            methodDetails.render(collector);
            collector.addLine();
        });
        collector.addLine();
        if (this.isRecord()) {
            collector.addLine("// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            collector.addLine("// record components");
            this.getRecordComponents().forEach(recordComponentDetails -> {
                recordComponentDetails.render(collector);
                collector.addLine();
            });
        }
        collector.unindent(1);
        collector.addLine("}");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        OBJECT_CLASS_DETAILS = new SimpleClassDetails(Object.class);
        CLASS_CLASS_DETAILS = new SimpleClassDetails(Class.class);
        VOID_CLASS_DETAILS = new SimpleClassDetails(Void.TYPE);
        VOID_OBJECT_CLASS_DETAILS = new SimpleClassDetails(Void.class);
    }

    @FunctionalInterface
    public static interface ClassDetailsConsumer
    extends Consumer<ClassDetails> {
        @Override
        public void accept(ClassDetails var1);
    }
}

