/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import org.hibernate.models.internal.IsResolvedTypeSwitch;
import org.hibernate.models.spi.ArrayTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassTypeDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.PrimitiveTypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeDetailsSwitch;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableReferenceDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.models.spi.VoidTypeDetails;
import org.hibernate.models.spi.WildcardTypeDetails;

public interface TypeDetails
extends TypeVariableScope {
    public String getName();

    public Kind getTypeKind();

    public boolean isImplementor(Class<?> var1);

    default public ClassTypeDetails asClassType() {
        throw new IllegalArgumentException("Not a class type - " + this);
    }

    default public PrimitiveTypeDetails asPrimitiveType() {
        throw new IllegalArgumentException("Not a primitive type - " + this);
    }

    default public VoidTypeDetails asVoidType() {
        throw new IllegalArgumentException("Not a void type - " + this);
    }

    default public ArrayTypeDetails asArrayType() {
        throw new IllegalArgumentException("Not an array type - " + this);
    }

    default public TypeVariableDetails asTypeVariable() {
        throw new IllegalArgumentException("Not a type variable - " + this);
    }

    default public ParameterizedTypeDetails asParameterizedType() {
        throw new IllegalArgumentException("Not a parameterized type - " + this);
    }

    default public TypeVariableReferenceDetails asTypeVariableReference() {
        throw new IllegalArgumentException("Not a type variable reference - " + this);
    }

    default public WildcardTypeDetails asWildcardType() {
        throw new IllegalArgumentException("Not a wildcard type - " + this);
    }

    default public boolean isResolved() {
        return TypeDetailsSwitch.switchType(this, IsResolvedTypeSwitch.IS_RESOLVED_SWITCH, null);
    }

    default public TypeDetails determineRelativeType(TypeVariableScope container) {
        return TypeDetailsHelper.resolveRelativeType(this, container);
    }

    @Override
    default public ClassDetails determineRawClass() {
        return TypeDetailsHelper.resolveRawClass(this);
    }

    public static enum Kind {
        CLASS,
        ARRAY,
        PRIMITIVE,
        VOID,
        TYPE_VARIABLE,
        WILDCARD_TYPE,
        PARAMETERIZED_TYPE,
        TYPE_VARIABLE_REFERENCE;

    }
}

