/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.internal.AnnotationUsageHelper;
import org.hibernate.models.internal.util.IndexedConsumer;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface ClassDetailsSupport
extends MutableClassDetails,
AnnotationTargetSupport {
    @Override
    default public void forEachField(IndexedConsumer<FieldDetails> consumer) {
        List<FieldDetails> fields = this.getFields();
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            consumer.accept(i, fields.get(i));
        }
    }

    @Override
    default public void forEachMethod(IndexedConsumer<MethodDetails> consumer) {
        List<MethodDetails> methods = this.getMethods();
        if (methods == null) {
            return;
        }
        for (int i = 0; i < methods.size(); ++i) {
            consumer.accept(i, methods.get(i));
        }
    }

    @Override
    default public <A extends Annotation> A getAnnotationUsage(AnnotationDescriptor<A> descriptor, SourceModelBuildingContext modelContext) {
        A localUsage = AnnotationUsageHelper.getUsage(descriptor, this.getUsageMap(), modelContext);
        if (localUsage != null) {
            return localUsage;
        }
        if (descriptor.isInherited() && this.getSuperClass() != null) {
            return this.getSuperClass().getAnnotationUsage(descriptor, modelContext);
        }
        return null;
    }

    @Override
    default public <A extends Annotation> A getAnnotationUsage(Class<A> annotationType, SourceModelBuildingContext modelContext) {
        return this.getAnnotationUsage(modelContext.getAnnotationDescriptorRegistry().getDescriptor(annotationType), modelContext);
    }

    @Override
    default public MutableClassDetails asClassDetails() {
        return this;
    }

    @Override
    default public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("ClassDetails cannot be cast as AnnotationDescriptor");
    }

    @Override
    default public MutableMemberDetails asMemberDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast as MemberDetails");
    }

    @Override
    default public FieldDetails asFieldDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast as FieldDetails");
    }

    @Override
    default public MethodDetails asMethodDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast as MethodDetails");
    }

    @Override
    default public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast as RecordComponentDetails");
    }
}

