/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.dynamic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.dynamic.AbstractAnnotationTarget;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class DynamicFieldDetails
extends AbstractAnnotationTarget
implements FieldDetails,
MutableMemberDetails {
    private final String name;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final int modifierFlags;
    private final boolean isArray;
    private final boolean isPlural;

    public DynamicFieldDetails(String name, TypeDetails type, ClassDetails declaringType, int modifierFlags, SourceModelBuildingContext buildingContext) {
        this(name, type, declaringType, modifierFlags, type != null && type.getName().startsWith("["), type != null && (type.isImplementor(Collection.class) || type.isImplementor(Map.class)), buildingContext);
    }

    public DynamicFieldDetails(String name, TypeDetails type, ClassDetails declaringType, int modifierFlags, boolean isArray, boolean isPlural, SourceModelBuildingContext buildingContext) {
        super(buildingContext);
        this.name = name;
        this.type = type;
        this.declaringType = declaringType;
        this.modifierFlags = modifierFlags;
        this.isArray = isArray;
        this.isPlural = isPlural;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeDetails getType() {
        return this.type;
    }

    @Override
    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isPlural() {
        return this.isPlural;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public int getModifiers() {
        return this.modifierFlags;
    }

    @Override
    public Member toJavaMember() {
        return null;
    }

    @Override
    public TypeDetails resolveRelativeType(TypeVariableScope container) {
        return this.type;
    }

    public String toString() {
        return "DynamicFieldDetails(" + this.name + ")";
    }

    @Override
    public FieldDetails asFieldDetails() {
        return this;
    }

    @Override
    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    @Override
    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as MethodDetails");
    }

    @Override
    public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as RecordComponentDetails");
    }

    @Override
    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as ClassDetails");
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("FieldDetails cannot be cast as AnnotationDescriptor");
    }
}

