/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import org.hibernate.models.spi.JandexValueConverter;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.Type;
import org.jboss.jandex.VoidType;

public class ClassValueConverter
implements JandexValueConverter<Class<?>> {
    public static final ClassValueConverter JANDEX_CLASS_VALUE_WRAPPER = new ClassValueConverter();

    @Override
    public Class<?> convert(AnnotationValue jandexValue, SourceModelBuildingContext modelContext) {
        Type classReference = jandexValue.asClass();
        if (classReference == VoidType.VOID) {
            return Void.TYPE;
        }
        return modelContext.getClassLoading().classForName(classReference.name().toString());
    }
}

