/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import org.hibernate.models.UnknownClassException;
import org.hibernate.models.internal.jandex.JandexClassDetails;
import org.hibernate.models.internal.jandex.JandexMethodDetails;
import org.hibernate.models.internal.jandex.JandexTypeSwitchStandard;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JandexBuilders
implements ClassDetailsBuilder {
    public static final JandexBuilders DEFAULT_BUILDER = new JandexBuilders();

    @Override
    public ClassDetails buildClassDetails(String name, SourceModelBuildingContext buildingContext) {
        return JandexBuilders.buildClassDetailsStatic(name, buildingContext.getJandexIndex(), buildingContext);
    }

    public static ClassDetails buildClassDetailsStatic(String name, SourceModelBuildingContext processingContext) {
        return JandexBuilders.buildClassDetailsStatic(name, processingContext.getJandexIndex(), processingContext);
    }

    public static ClassDetails buildClassDetailsStatic(String name, IndexView jandexIndex, SourceModelBuildingContext processingContext) {
        if ("void".equals(name)) {
            name = Void.class.getName();
        }
        ClassInfo classInfo = jandexIndex.getClassByName(name);
        if (StringHelper.isNotEmpty(name) && classInfo == null) {
            Class<?> primitiveClass = JandexBuilders.resolvePrimitiveClass(name);
            if (primitiveClass != null) {
                return JdkBuilders.buildClassDetailsStatic(primitiveClass, processingContext);
            }
            throw new UnknownClassException("Could not find class [" + name + "] in Jandex index");
        }
        return new JandexClassDetails(classInfo, processingContext);
    }

    public static Class<?> resolvePrimitiveClass(String className) {
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if (Boolean.class.getSimpleName().equalsIgnoreCase(className) || Boolean.class.getName().equals(className)) {
            return Boolean.class;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        if (Byte.class.getSimpleName().equals(className) || Byte.class.getName().equals(className)) {
            return Byte.class;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if (Short.class.getSimpleName().equals(className) || Short.class.getName().equals(className)) {
            return Short.class;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if (Integer.class.getSimpleName().equals(className) || Integer.class.getName().equals(className)) {
            return Integer.class;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if (Long.class.getSimpleName().equals(className) || Long.class.getName().equals(className)) {
            return Long.class;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if (Double.class.getSimpleName().equals(className) || Double.class.getName().equals(className)) {
            return Double.class;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if (Float.class.getSimpleName().equals(className) || Float.class.getName().equals(className)) {
            return Float.class;
        }
        return null;
    }

    public static JandexMethodDetails buildMethodDetails(MethodInfo method, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        Type returnType;
        if (method.parametersCount() == 0 && (returnType = method.returnType()).kind() != Type.Kind.VOID) {
            String methodName = method.name();
            if (methodName.startsWith("get")) {
                return new JandexMethodDetails(method, MethodDetails.MethodKind.GETTER, JandexTypeSwitchStandard.switchType(returnType, declaringType, buildingContext), declaringType, buildingContext);
            }
            if (JandexBuilders.isBoolean(returnType) && (methodName.startsWith("is") || methodName.startsWith("has") || methodName.startsWith("was"))) {
                return new JandexMethodDetails(method, MethodDetails.MethodKind.GETTER, JandexTypeSwitchStandard.switchType(returnType, declaringType, buildingContext), declaringType, buildingContext);
            }
        }
        if (method.parametersCount() == 1 && method.returnType().kind() == Type.Kind.VOID && method.name().startsWith("set")) {
            return new JandexMethodDetails(method, MethodDetails.MethodKind.SETTER, JandexTypeSwitchStandard.switchType(method.parameterType(0), declaringType, buildingContext), declaringType, buildingContext);
        }
        return new JandexMethodDetails(method, MethodDetails.MethodKind.OTHER, null, declaringType, buildingContext);
    }

    private static boolean isBoolean(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return type.name().toString().equals("boolean");
        }
        return type.name().toString().equals("java.lang.Boolean");
    }
}

