/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.JandexValueExtractor;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class AnnotationUsageBuilder {
    public static final DotName REPEATABLE = DotName.createSimple(Repeatable.class);
    public static final DotName TARGET = DotName.createSimple(Target.class);
    public static final DotName RETENTION = DotName.createSimple(Retention.class);
    public static final DotName DOCUMENTED = DotName.createSimple(Documented.class);

    public static Map<Class<? extends Annotation>, ? extends Annotation> collectUsages(AnnotationTarget jandexAnnotationTarget, SourceModelBuildingContext buildingContext) {
        if (jandexAnnotationTarget == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        AnnotationUsageBuilder.processAnnotations(jandexAnnotationTarget.declaredAnnotations(), result::put, buildingContext);
        return result;
    }

    public static void processAnnotations(Collection<AnnotationInstance> annotations, BiConsumer<Class<? extends Annotation>, Annotation> consumer, SourceModelBuildingContext buildingContext) {
        AnnotationDescriptorRegistry annotationDescriptorRegistry = buildingContext.getAnnotationDescriptorRegistry();
        for (AnnotationInstance annotation : annotations) {
            if (annotation.name().equals((Object)DOCUMENTED) || annotation.name().equals((Object)REPEATABLE) || annotation.name().equals((Object)RETENTION) || annotation.name().equals((Object)TARGET)) continue;
            Class annotationType = buildingContext.getClassLoading().classForName(annotation.name().toString());
            AnnotationDescriptor annotationDescriptor = annotationDescriptorRegistry.getDescriptor(annotationType);
            Object usage = AnnotationUsageBuilder.makeUsage(annotation, annotationDescriptor, buildingContext);
            consumer.accept(annotationType, (Annotation)usage);
        }
    }

    public static <A extends Annotation> A makeUsage(AnnotationInstance annotation, AnnotationDescriptor<A> annotationDescriptor, SourceModelBuildingContext modelContext) {
        return annotationDescriptor.createUsage(annotation, modelContext);
    }

    public static <A extends Annotation> Map<String, Object> extractAttributeValues(AnnotationInstance annotationInstance, AnnotationDescriptor<A> annotationDescriptor, SourceModelBuildingContext modelContext) {
        if (CollectionHelper.isEmpty(annotationDescriptor.getAttributes())) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, Object> valueMap = new ConcurrentHashMap<String, Object>();
        for (int i = 0; i < annotationDescriptor.getAttributes().size(); ++i) {
            AttributeDescriptor<?> attributeDescriptor = annotationDescriptor.getAttributes().get(i);
            JandexValueExtractor<?> extractor = attributeDescriptor.getTypeDescriptor().createJandexValueExtractor(modelContext);
            Object attributeValue = extractor.extractValue(annotationInstance, attributeDescriptor, modelContext);
            valueMap.put(attributeDescriptor.getName(), attributeValue);
        }
        return valueMap;
    }

    private AnnotationUsageBuilder() {
    }
}

