/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.internal.ClassDetailsSupport;
import org.hibernate.models.internal.jdk.AbstractJdkAnnotationTarget;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.jdk.JdkFieldDetails;
import org.hibernate.models.internal.jdk.JdkRecordComponentDetails;
import org.hibernate.models.internal.jdk.JdkTrackingTypeSwitcher;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class JdkClassDetails
extends AbstractJdkAnnotationTarget
implements ClassDetailsSupport {
    private final String name;
    private final Class<?> managedClass;
    private final ClassDetails superClass;
    private List<TypeDetails> interfaces;
    private TypeDetails genericSuperType;
    private List<TypeVariableDetails> typeParameters;
    private List<FieldDetails> fields;
    private List<MethodDetails> methods;
    private List<RecordComponentDetails> recordComponents;

    public JdkClassDetails(Class<?> managedClass, SourceModelBuildingContext modelContext) {
        this(managedClass.getName(), managedClass, modelContext);
    }

    public JdkClassDetails(String name, Class<?> managedClass, SourceModelBuildingContext modelContext) {
        super(managedClass::getAnnotations, modelContext);
        this.name = name;
        this.managedClass = managedClass;
        this.superClass = JdkClassDetails.determineSuperClass(managedClass, modelContext);
    }

    private static ClassDetails determineSuperClass(Class<?> managedClass, SourceModelBuildingContext modelContext) {
        Class<?> superclass = managedClass.getSuperclass();
        if (superclass == null) {
            return null;
        }
        ClassDetailsRegistry classDetailsRegistry = modelContext.getClassDetailsRegistry();
        return classDetailsRegistry.resolveClassDetails(superclass.getName(), n -> JdkBuilders.buildClassDetailsStatic(superclass, modelContext));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.managedClass.getName();
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public <X> Class<X> toJavaClass() {
        return this.managedClass;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.managedClass.getModifiers());
    }

    @Override
    public boolean isInterface() {
        return this.managedClass.isInterface();
    }

    @Override
    public boolean isEnum() {
        return this.managedClass.isEnum();
    }

    @Override
    public boolean isRecord() {
        return this.managedClass.isRecord();
    }

    @Override
    public ClassDetails getSuperClass() {
        return this.superClass;
    }

    @Override
    public TypeDetails getGenericSuperType() {
        if (this.genericSuperType == null && this.managedClass.getGenericSuperclass() != null) {
            this.genericSuperType = new JdkTrackingTypeSwitcher(this.getModelContext()).switchType(this.managedClass.getGenericSuperclass());
        }
        return this.genericSuperType;
    }

    @Override
    public List<TypeDetails> getImplementedInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.collectInterfaces();
        }
        return this.interfaces;
    }

    private List<TypeDetails> collectInterfaces() {
        Object[] jdkInterfaces = this.managedClass.getGenericInterfaces();
        if (CollectionHelper.isEmpty(jdkInterfaces)) {
            return Collections.emptyList();
        }
        ArrayList<TypeDetails> result = CollectionHelper.arrayList(jdkInterfaces.length);
        JdkTrackingTypeSwitcher typeSwitcher = new JdkTrackingTypeSwitcher(this.getModelContext());
        for (Object jdkInterface : jdkInterfaces) {
            TypeDetails switchedInterfaceType = typeSwitcher.switchType((Type)jdkInterface);
            result.add(switchedInterfaceType);
        }
        return result;
    }

    @Override
    public List<TypeVariableDetails> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = this.collectTypeParameters();
        }
        return this.typeParameters;
    }

    private List<TypeVariableDetails> collectTypeParameters() {
        Object[] jdkTypeParameters = this.managedClass.getTypeParameters();
        if (CollectionHelper.isEmpty(jdkTypeParameters)) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariableDetails> result = CollectionHelper.arrayList(jdkTypeParameters.length);
        JdkTrackingTypeSwitcher typeSwitcher = new JdkTrackingTypeSwitcher(this.getModelContext());
        for (Object jdkTypeParameter : jdkTypeParameters) {
            result.add((TypeVariableDetails)typeSwitcher.switchType((Type)jdkTypeParameter));
        }
        return result;
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        return checkType.isAssignableFrom(this.managedClass);
    }

    @Override
    public List<FieldDetails> getFields() {
        if (this.fields == null) {
            Field[] reflectionFields = this.managedClass.getDeclaredFields();
            this.fields = CollectionHelper.arrayList(reflectionFields.length);
            for (int i = 0; i < reflectionFields.length; ++i) {
                Field reflectionField = reflectionFields[i];
                this.fields.add(new JdkFieldDetails(reflectionField, this, this.getModelContext()));
            }
        }
        return this.fields;
    }

    @Override
    public void addField(FieldDetails fieldDetails) {
        this.getFields().add(fieldDetails);
    }

    @Override
    public List<MethodDetails> getMethods() {
        if (this.methods == null) {
            Method[] reflectionMethods = this.managedClass.getDeclaredMethods();
            this.methods = CollectionHelper.arrayList(reflectionMethods.length);
            for (int i = 0; i < reflectionMethods.length; ++i) {
                this.methods.add(JdkBuilders.buildMethodDetails(reflectionMethods[i], this, this.getModelContext()));
            }
        }
        return this.methods;
    }

    @Override
    public void addMethod(MethodDetails methodDetails) {
        this.getMethods().add(methodDetails);
    }

    @Override
    public List<RecordComponentDetails> getRecordComponents() {
        if (!this.isRecord()) {
            return Collections.emptyList();
        }
        if (this.recordComponents == null) {
            RecordComponent[] jdkRecordComponents = this.managedClass.getRecordComponents();
            this.recordComponents = CollectionHelper.arrayList(jdkRecordComponents.length);
            for (int i = 0; i < jdkRecordComponents.length; ++i) {
                this.recordComponents.add(new JdkRecordComponentDetails(jdkRecordComponents[i], this, this.getModelContext()));
            }
        }
        return this.recordComponents;
    }

    public String toString() {
        return "JdkClassDetails(" + this.name + ")";
    }
}

