/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.models.internal.AbstractAnnotationDescriptor;
import org.hibernate.models.internal.AnnotationDescriptorBuilding;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.MutableAnnotationDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class OrmAnnotationDescriptor<A extends Annotation, C extends A>
extends AbstractAnnotationDescriptor<A>
implements MutableAnnotationDescriptor<A, C> {
    private final Class<C> concreteClass;
    private final List<AttributeDescriptor<?>> attributeDescriptors;
    private DynamicCreator<A, C> dynamicCreator;
    private JdkCreator<A, C> jdkCreator;
    private DeTypedCreator<A, C> deTypedCreator;

    public OrmAnnotationDescriptor(Class<A> annotationType, Class<C> concreteClass) {
        this(annotationType, concreteClass, null);
    }

    public OrmAnnotationDescriptor(Class<A> annotationType, Class<C> concreteClass, AnnotationDescriptor<?> repeatableContainer) {
        super(annotationType, AnnotationHelper.extractTargets(annotationType), AnnotationHelper.isInherited(annotationType), repeatableContainer);
        this.concreteClass = concreteClass;
        this.attributeDescriptors = AnnotationDescriptorBuilding.extractAttributeDescriptors(annotationType);
    }

    @Override
    public Class<C> getMutableAnnotationType() {
        return this.concreteClass;
    }

    @Override
    public Map<Class<? extends Annotation>, ? extends Annotation> getUsageMap() {
        return Collections.emptyMap();
    }

    @Override
    public C createUsage(SourceModelBuildingContext context) {
        if (this.dynamicCreator == null) {
            this.dynamicCreator = new DynamicCreator(this.getAnnotationType(), this.concreteClass);
        }
        return this.dynamicCreator.createUsage(context);
    }

    @Override
    public C createUsage(A jdkAnnotation, SourceModelBuildingContext context) {
        if (this.jdkCreator == null) {
            this.jdkCreator = new JdkCreator(this.getAnnotationType(), this.concreteClass);
        }
        return this.jdkCreator.createUsage(jdkAnnotation, context);
    }

    @Override
    public A createUsage(Map<String, Object> attributeValues, SourceModelBuildingContext context) {
        if (this.deTypedCreator == null) {
            this.deTypedCreator = new DeTypedCreator(this.getAnnotationType(), this.concreteClass);
        }
        return (A)this.deTypedCreator.createUsage(attributeValues, context);
    }

    @Override
    public List<AttributeDescriptor<?>> getAttributes() {
        return this.attributeDescriptors;
    }

    public String toString() {
        return String.format("AnnotationDescriptor(%s)", this.getAnnotationType().getName());
    }

    public static class DynamicCreator<A extends Annotation, C extends A> {
        private final Constructor<C> constructor;

        public DynamicCreator(Class<A> annotationType, Class<C> concreteClass) {
            this(DynamicCreator.resolveConstructor(concreteClass));
        }

        private static <A extends Annotation, C extends A> Constructor<C> resolveConstructor(Class<C> concreteClass) {
            try {
                return concreteClass.getDeclaredConstructor(SourceModelBuildingContext.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public DynamicCreator(Constructor<C> constructor) {
            this.constructor = constructor;
        }

        public C createUsage(SourceModelBuildingContext context) {
            try {
                return (C)((Annotation)this.constructor.newInstance(context));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class JdkCreator<A extends Annotation, C extends A> {
        private final Constructor<C> constructor;

        public JdkCreator(Class<A> annotationType, Class<C> concreteClass) {
            this(JdkCreator.resolveConstructor(annotationType, concreteClass));
        }

        private static <A extends Annotation, C extends A> Constructor<C> resolveConstructor(Class<A> annotationType, Class<C> concreteClass) {
            try {
                return concreteClass.getDeclaredConstructor(annotationType, SourceModelBuildingContext.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public JdkCreator(Constructor<C> constructor) {
            this.constructor = constructor;
        }

        public C createUsage(A jdkAnnotation, SourceModelBuildingContext context) {
            try {
                return (C)((Annotation)this.constructor.newInstance(jdkAnnotation, context));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DeTypedCreator<A extends Annotation, C extends A> {
        private final Constructor<C> constructor;

        public DeTypedCreator(Class<A> annotationType, Class<C> concreteClass) {
            this(DeTypedCreator.resolveConstructor(concreteClass));
        }

        private static <A extends Annotation, C extends A> Constructor<C> resolveConstructor(Class<C> concreteClass) {
            try {
                return concreteClass.getDeclaredConstructor(Map.class, SourceModelBuildingContext.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public DeTypedCreator(Constructor<C> constructor) {
            this.constructor = constructor;
        }

        public C createUsage(Map<String, ?> attributeValues, SourceModelBuildingContext context) {
            try {
                return (C)((Annotation)this.constructor.newInstance(attributeValues, context));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

