/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.models.internal.ModifierUtils;
import org.hibernate.models.internal.util.IndexedConsumer;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class SimpleClassDetails
implements ClassDetails {
    private final Class<?> clazz;
    private final ClassDetails superClassDetails;
    private final TypeDetails genericSuperTypeDetails;

    public SimpleClassDetails(Class<?> clazz) {
        this(clazz, OBJECT_CLASS_DETAILS, null);
    }

    public SimpleClassDetails(Class<?> clazz, ClassDetails superClassDetails, TypeDetails genericSuperTypeDetails) {
        this.clazz = clazz;
        this.superClassDetails = superClassDetails;
        this.genericSuperTypeDetails = genericSuperTypeDetails;
    }

    @Override
    public String getName() {
        return this.getClassName();
    }

    @Override
    public String getClassName() {
        return this.clazz.getName();
    }

    @Override
    public ClassDetails getSuperClass() {
        return this.superClassDetails;
    }

    @Override
    public TypeDetails getGenericSuperType() {
        return this.genericSuperTypeDetails;
    }

    @Override
    public <X> Class<X> toJavaClass() {
        return this.clazz;
    }

    public String toString() {
        return "ClassDetails(" + this.clazz.getName() + ")";
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return ModifierUtils.isAbstract(this.clazz.getModifiers());
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    @Override
    public boolean isRecord() {
        return this.clazz.isRecord();
    }

    @Override
    public List<TypeDetails> getImplementedInterfaces() {
        return Collections.emptyList();
    }

    @Override
    public List<TypeVariableDetails> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        return checkType.isAssignableFrom(this.clazz);
    }

    @Override
    public List<FieldDetails> getFields() {
        return Collections.emptyList();
    }

    @Override
    public void forEachField(IndexedConsumer<FieldDetails> consumer) {
    }

    @Override
    public List<MethodDetails> getMethods() {
        return Collections.emptyList();
    }

    @Override
    public void forEachMethod(IndexedConsumer<MethodDetails> consumer) {
    }

    @Override
    public List<RecordComponentDetails> getRecordComponents() {
        return Collections.emptyList();
    }

    @Override
    public void forEachRecordComponent(IndexedConsumer<RecordComponentDetails> consumer) {
    }

    @Override
    public Collection<? extends Annotation> getDirectAnnotationUsages() {
        return Collections.emptyList();
    }

    @Override
    public <A extends Annotation> boolean hasDirectAnnotationUsage(Class<A> type) {
        return false;
    }

    @Override
    public <A extends Annotation> A getDirectAnnotationUsage(AnnotationDescriptor<A> descriptor) {
        return null;
    }

    @Override
    public <A extends Annotation> A getDirectAnnotationUsage(Class<A> type) {
        return null;
    }

    @Override
    public <A extends Annotation> boolean hasAnnotationUsage(Class<A> type, SourceModelBuildingContext modelContext) {
        return false;
    }

    @Override
    public <A extends Annotation> A getAnnotationUsage(AnnotationDescriptor<A> descriptor, SourceModelBuildingContext modelContext) {
        return null;
    }

    @Override
    public <A extends Annotation> A getAnnotationUsage(Class<A> type, SourceModelBuildingContext modelContext) {
        return null;
    }

    @Override
    public <A extends Annotation> A locateAnnotationUsage(Class<A> type, SourceModelBuildingContext modelContext) {
        return null;
    }

    @Override
    public <A extends Annotation> A[] getRepeatedAnnotationUsages(AnnotationDescriptor<A> type, SourceModelBuildingContext modelContext) {
        return null;
    }

    @Override
    public <A extends Annotation, C extends Annotation> void forEachRepeatedAnnotationUsages(Class<A> repeatable, Class<C> container, SourceModelBuildingContext modelContext, Consumer<A> consumer) {
    }

    @Override
    public <A extends Annotation> List<? extends Annotation> getMetaAnnotated(Class<A> metaAnnotationType, SourceModelBuildingContext modelContext) {
        return Collections.emptyList();
    }

    @Override
    public <X extends Annotation> X getNamedAnnotationUsage(AnnotationDescriptor<X> type, String matchName, String attributeToMatch, SourceModelBuildingContext modelContext) {
        return null;
    }

    @Override
    public <X extends Annotation> X getNamedAnnotationUsage(Class<X> type, String matchName, String attributeToMatch, SourceModelBuildingContext modelContext) {
        return null;
    }
}

