/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.hibernate.models.UnknownClassException;
import org.hibernate.models.spi.ClassLoading;

public class SimpleClassLoading
implements ClassLoading {
    public static final SimpleClassLoading SIMPLE_CLASS_LOADING = new SimpleClassLoading();

    @Override
    public <T> Class<T> classForName(String name) {
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new UnknownClassException("Unable to locate class - " + name, e);
        }
    }

    @Override
    public <T> Class<T> findClassForName(String name) {
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Package packageForName(String name) {
        return this.getClass().getClassLoader().getDefinedPackage(name);
    }

    @Override
    public URL locateResource(String resourceName) {
        return this.getClass().getClassLoader().getResource(resourceName);
    }

    @Override
    public <S> Collection<S> loadJavaServices(Class<S> serviceType) {
        ServiceLoader<S> loadedServices = ServiceLoader.load(serviceType);
        Iterator<S> iterator = loadedServices.iterator();
        HashSet<S> services = new HashSet<S>();
        while (iterator.hasNext()) {
            services.add(iterator.next());
        }
        return services;
    }
}

