/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.models.UnknownClassException;
import org.hibernate.models.internal.AnnotationDescriptorRegistryStandard;
import org.hibernate.models.internal.ModifierUtils;
import org.hibernate.models.internal.PrimitiveKind;
import org.hibernate.models.internal.StandardAnnotationDescriptor;
import org.hibernate.models.internal.jdk.JdkClassDetails;
import org.hibernate.models.internal.jdk.JdkMethodDetails;
import org.hibernate.models.internal.jdk.JdkTrackingTypeSwitcher;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;

public class JdkBuilders
implements ClassDetailsBuilder {
    public static final JdkBuilders DEFAULT_BUILDER = new JdkBuilders();

    @Override
    public JdkClassDetails buildClassDetails(String name, SourceModelBuildingContext buildingContext) {
        return JdkBuilders.buildClassDetailsStatic(name, buildingContext);
    }

    public static JdkClassDetails buildClassDetailsStatic(String name, SourceModelBuildingContext buildingContext) {
        if (Character.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Character.TYPE, buildingContext);
        }
        if (Byte.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Byte.TYPE, buildingContext);
        }
        if (Boolean.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Boolean.TYPE, buildingContext);
        }
        if (Short.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Short.TYPE, buildingContext);
        }
        if (Integer.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Integer.TYPE, buildingContext);
        }
        if (Long.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Long.TYPE, buildingContext);
        }
        if (Float.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Float.TYPE, buildingContext);
        }
        if (Double.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Double.TYPE, buildingContext);
        }
        if (name.startsWith("[")) {
            return JdkBuilders.buildArrayClassDetails(name, buildingContext);
        }
        try {
            Class loadedClass = buildingContext.getClassLoading().classForName(name);
            return JdkBuilders.buildClassDetailsStatic(loadedClass, buildingContext);
        }
        catch (UnknownClassException e) {
            try {
                Class packageInfoClass = buildingContext.getClassLoading().classForName(name + ".package-info");
                return JdkBuilders.buildClassDetailsStatic(packageInfoClass, buildingContext);
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    private static JdkClassDetails buildArrayClassDetails(String name, SourceModelBuildingContext buildingContext) {
        assert (name.startsWith("["));
        int dimensionCount = StringHelper.countArrayDimensions(name);
        assert (dimensionCount > 0);
        String componentTypeName = name.substring(1);
        ClassDetails componentTypeDetails = JdkBuilders.resolveArrayComponentType(componentTypeName, buildingContext);
        Class javaClass = componentTypeDetails.toJavaClass();
        TypeDescriptor.OfField arrayType = javaClass.arrayType();
        return new JdkClassDetails((Class<?>)arrayType, buildingContext);
    }

    private static ClassDetails resolveArrayComponentType(String componentTypeName, SourceModelBuildingContext buildingContext) {
        if (componentTypeName.startsWith("[")) {
            return JdkBuilders.buildArrayClassDetails(componentTypeName, buildingContext);
        }
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        if (componentTypeName.length() == 1) {
            PrimitiveKind primitiveKind = PrimitiveKind.resolveFromTypeChar(componentTypeName.charAt(0));
            return classDetailsRegistry.resolveClassDetails(primitiveKind.getTypeName());
        }
        if (!componentTypeName.startsWith("L")) {
            throw new AssertionError((Object)("Unexpected array component type prefix - " + componentTypeName));
        }
        if (!componentTypeName.endsWith(";")) {
            throw new AssertionError((Object)("Unexpected array component type format : no semi-colon - " + componentTypeName));
        }
        String objectComponentTypeName = componentTypeName.substring(1, componentTypeName.length() - 1);
        return classDetailsRegistry.resolveClassDetails(objectComponentTypeName.replace('/', '.'));
    }

    public static JdkClassDetails buildClassDetailsStatic(Class<?> javaClass, SourceModelBuildingContext buildingContext) {
        return new JdkClassDetails(javaClass, buildingContext);
    }

    public static JdkMethodDetails buildMethodDetails(Method method, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        Class<?> returnType;
        if (method.getParameterCount() == 0 && !JdkBuilders.isVoid(returnType = method.getReturnType()) && !ModifierUtils.isStatic(method.getModifiers())) {
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                return JdkBuilders.buildGetterDetails(method, declaringType, buildingContext);
            }
            if (JdkBuilders.isBoolean(returnType) && methodName.startsWith("is")) {
                return JdkBuilders.buildGetterDetails(method, declaringType, buildingContext);
            }
        }
        if (method.getParameterCount() == 1 && JdkBuilders.isVoid(method.getReturnType()) && !ModifierUtils.isStatic(method.getModifiers()) && method.getName().startsWith("set")) {
            return JdkBuilders.buildSetterDetails(method, declaringType, buildingContext);
        }
        return new JdkMethodDetails(method, MethodDetails.MethodKind.OTHER, null, declaringType, buildingContext);
    }

    public static JdkMethodDetails buildGetterDetails(Method method, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        return new JdkMethodDetails(method, MethodDetails.MethodKind.GETTER, JdkBuilders.toTypeDetails(method.getGenericReturnType(), buildingContext), declaringType, buildingContext);
    }

    private static TypeDetails toTypeDetails(Type genericType, SourceModelBuildingContext buildingContext) {
        return new JdkTrackingTypeSwitcher(buildingContext).switchType(genericType);
    }

    public static JdkMethodDetails buildSetterDetails(Method method, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        return new JdkMethodDetails(method, MethodDetails.MethodKind.SETTER, JdkBuilders.toTypeDetails(method.getGenericParameterTypes()[0], buildingContext), declaringType, buildingContext);
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    public static boolean isVoid(Class<?> type) {
        return type == Void.TYPE || type == Void.class;
    }

    public static <A extends Annotation> AnnotationDescriptor<A> buildAnnotationDescriptor(Class<A> annotationType, SourceModelBuildingContext modelContext) {
        return JdkBuilders.buildAnnotationDescriptor(annotationType, JdkBuilders.resolveRepeatableContainerDescriptor(annotationType, modelContext), modelContext);
    }

    public static <A extends Annotation, C extends Annotation> AnnotationDescriptor<C> resolveRepeatableContainerDescriptor(Class<A> annotationType, SourceModelBuildingContext modelContext) {
        Repeatable repeatableAnnotation = annotationType.getAnnotation(Repeatable.class);
        if (repeatableAnnotation == null) {
            return null;
        }
        AnnotationDescriptorRegistry descriptorRegistry = modelContext.getAnnotationDescriptorRegistry();
        AnnotationDescriptor<? extends Annotation> containerDescriptor = descriptorRegistry.getDescriptor(repeatableAnnotation.value());
        ((AnnotationDescriptorRegistryStandard)descriptorRegistry).register(containerDescriptor);
        return containerDescriptor;
    }

    public static <A extends Annotation> AnnotationDescriptor<A> buildAnnotationDescriptor(Class<A> annotationType, AnnotationDescriptor<?> repeatableContainer, SourceModelBuildingContext modelContext) {
        return new StandardAnnotationDescriptor<A>(annotationType, repeatableContainer, modelContext);
    }
}

