/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.jdk.AbstractJdkAnnotationTarget;
import org.hibernate.models.internal.jdk.JdkTrackingTypeSwitcher;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;

public class JdkRecordComponentDetails
extends AbstractJdkAnnotationTarget
implements RecordComponentDetails,
MutableMemberDetails {
    private final RecordComponent recordComponent;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final boolean isArray;
    private final boolean isPlural;

    public JdkRecordComponentDetails(RecordComponent recordComponent, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        super(recordComponent::getAnnotations, buildingContext);
        this.recordComponent = recordComponent;
        this.declaringType = declaringType;
        this.type = JdkTrackingTypeSwitcher.standardSwitchType(recordComponent.getGenericType(), buildingContext);
        this.isArray = recordComponent.getType().isArray();
        this.isPlural = this.isArray || Collection.class.isAssignableFrom(recordComponent.getType()) || Map.class.isAssignableFrom(recordComponent.getType());
    }

    @Override
    public String getName() {
        return this.recordComponent.getName();
    }

    @Override
    public TypeDetails getType() {
        return this.type;
    }

    @Override
    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isPlural() {
        return this.isPlural;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public Member toJavaMember() {
        return null;
    }

    @Override
    public int getModifiers() {
        return this.recordComponent.getAccessor().getModifiers();
    }

    public String toString() {
        return "JdkRecordComponentDetails(" + this.getName() + ")";
    }

    @Override
    public RecordComponentDetails asRecordComponentDetails() {
        return this;
    }

    @Override
    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    @Override
    public FieldDetails asFieldDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as FieldDetails");
    }

    @Override
    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as MethodDetails");
    }

    @Override
    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as ClassDetails");
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as AnnotationDescriptor");
    }
}

