/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.rendering.internal;

import org.hibernate.models.rendering.spi.AbstractRenderer;
import org.hibernate.models.rendering.spi.RenderingTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelContext;

public class SimpleRenderer
extends AbstractRenderer {
    private final RenderingTarget renderingTarget;

    public SimpleRenderer(RenderingTarget renderingTarget) {
        this.renderingTarget = renderingTarget;
    }

    @Override
    protected RenderingTarget getRenderingTarget() {
        return this.renderingTarget;
    }

    @Override
    public void renderClassDetails(ClassDetails classDetails, SourceModelContext context) {
        String typeDeclarationPattern = classDetails.isInterface() ? "interface %s {" : (classDetails.isRecord() ? "record %s {" : "class %s {");
        this.renderingTarget.addLine(typeDeclarationPattern, classDetails.getName());
        this.renderingTarget.indent(1);
        this.renderingTarget.addLine("// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        this.renderingTarget.addLine("// fields");
        classDetails.forEachField((index, fieldDetails) -> {
            this.renderField((FieldDetails)fieldDetails, context);
            this.renderingTarget.addLine();
        });
        this.renderingTarget.addLine();
        this.renderingTarget.addLine("// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        this.renderingTarget.addLine("// methods");
        classDetails.forEachMethod((index, methodDetails) -> {
            this.renderMethod((MethodDetails)methodDetails, context);
            this.renderingTarget.addLine();
        });
        this.renderingTarget.addLine();
        if (classDetails.isRecord()) {
            this.renderingTarget.addLine("// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            this.renderingTarget.addLine("// record components");
            classDetails.forEachRecordComponent((index, recordComponentDetails) -> {
                this.renderRecordComponent((RecordComponentDetails)recordComponentDetails, context);
                this.renderingTarget.addLine();
            });
        }
        this.renderingTarget.unindent(1);
        this.renderingTarget.addLine("}");
    }

    @Override
    public void renderFieldDetails(FieldDetails fieldDetails, SourceModelContext context) {
        this.renderingTarget.addLine("%s %s", fieldDetails.getType().determineRawClass().getName(), fieldDetails.getName());
    }

    @Override
    public void renderMethodDetails(MethodDetails methodDetails, SourceModelContext context) {
        this.renderingTarget.addLine("%s %s (%s)", methodDetails.getType() == null ? "void" : methodDetails.getType().determineRawClass().getName(), methodDetails.getName(), methodDetails.getMethodKind().name());
        this.renderingTarget.indent(2);
        methodDetails.getArgumentTypes().forEach(arg -> this.renderingTarget.addLine(" - %s", arg.getName()));
        this.renderingTarget.unindent(2);
    }

    @Override
    public void renderRecordComponentDetails(RecordComponentDetails recordComponentDetails, SourceModelContext context) {
        this.renderingTarget.addLine("%s %s", recordComponentDetails.getType().determineRawClass().getName(), recordComponentDetails.getName());
    }
}

