/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Locale;
import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.internal.jdk.JdkNestedValueConverter;
import org.hibernate.models.internal.jdk.JdkNestedValueExtractor;
import org.hibernate.models.rendering.spi.Renderer;
import org.hibernate.models.rendering.spi.RenderingTarget;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.JdkValueConverter;
import org.hibernate.models.spi.JdkValueExtractor;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.SourceModelContext;

public class NestedTypeDescriptor<A extends Annotation>
extends AbstractTypeDescriptor<A> {
    private final Class<A> annotationType;
    private AnnotationDescriptor<A> descriptor;
    private JdkNestedValueConverter<A> jdkConverter;
    private JdkNestedValueExtractor<A> jdkExtractor;

    public NestedTypeDescriptor(Class<A> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public Class<A> getValueType() {
        return this.annotationType;
    }

    private AnnotationDescriptor<A> resolveDescriptor(SourceModelContext context) {
        if (this.descriptor == null) {
            this.descriptor = context.getAnnotationDescriptorRegistry().getDescriptor(this.annotationType);
        }
        return this.descriptor;
    }

    @Override
    public JdkValueConverter<A> createJdkValueConverter(SourceModelBuildingContext modelContext) {
        return this.resolveJdkValueConverter(modelContext);
    }

    public JdkNestedValueConverter<A> resolveJdkValueConverter(SourceModelBuildingContext modelContext) {
        if (this.jdkConverter == null) {
            this.jdkConverter = new JdkNestedValueConverter<A>(this.resolveDescriptor(modelContext));
        }
        return this.jdkConverter;
    }

    @Override
    public JdkValueExtractor<A> createJdkValueExtractor(SourceModelBuildingContext modelContext) {
        return this.resolveJdkValueExtractor(modelContext);
    }

    public JdkValueExtractor<A> resolveJdkValueExtractor(SourceModelBuildingContext modelContext) {
        if (this.jdkExtractor == null) {
            this.jdkExtractor = new JdkNestedValueExtractor<A>(this.resolveJdkValueConverter(modelContext));
        }
        return this.jdkExtractor;
    }

    @Override
    public Object unwrap(A value) {
        return value;
    }

    @Override
    public void render(String name, Object attributeValue, RenderingTarget target, Renderer renderer, SourceModelContext modelContext) {
        renderer.renderNestedAnnotation(name, (Annotation)attributeValue, modelContext);
    }

    @Override
    public void render(Object attributeValue, RenderingTarget target, Renderer renderer, SourceModelContext modelContext) {
        renderer.renderNestedAnnotation((Annotation)attributeValue, modelContext);
    }

    @Override
    public A[] makeArray(int size, SourceModelBuildingContext modelContext) {
        return (Annotation[])Array.newInstance(this.resolveDescriptor(modelContext).getAnnotationType(), size);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "AttributeTypeDescriptor(%s)", this.descriptor.getAnnotationType().getName());
    }
}

