/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.serial.internal;

import org.hibernate.models.serial.internal.StorableContextImpl;
import org.hibernate.models.serial.spi.SerialClassDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class ClassDetailsBuilderImpl
implements ClassDetailsBuilder {
    private StorableContextImpl serialContext;

    public ClassDetailsBuilderImpl(StorableContextImpl serialContext, ClassLoading classLoading) {
        this.serialContext = serialContext;
    }

    @Override
    public ClassDetails buildClassDetails(String name, SourceModelBuildingContext buildingContext) {
        if (this.serialContext == null) {
            throw new IllegalStateException("Building context is now immutable");
        }
        SerialClassDetails serialClassDetails = this.serialContext.getSerialClassDetailsMap().get(name);
        return (ClassDetails)serialClassDetails.fromStorableForm(buildingContext);
    }

    public void invalidate() {
        this.serialContext = null;
    }
}

