/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.models.internal.BasicModelBuildingContextImpl;
import org.hibernate.models.internal.ModelsLogging;
import org.hibernate.models.internal.SimpleClassLoading;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.SourceModelBuildingContextProvider;

public class ModelsConfiguration {
    private final Map<Object, Object> configValues = new HashMap<Object, Object>();
    private ClassLoading classLoading = SimpleClassLoading.SIMPLE_CLASS_LOADING;
    private RegistryPrimer registryPrimer;
    private SourceModelBuildingContextProvider explicitContextProvider;

    public Map<Object, Object> getConfigValues() {
        return this.configValues;
    }

    public Object configValue(Object key, Object value) {
        return this.configValues.put(key, value);
    }

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public void setClassLoading(ClassLoading classLoading) {
        this.classLoading = classLoading;
    }

    public RegistryPrimer getRegistryPrimer() {
        return this.registryPrimer;
    }

    public void setRegistryPrimer(RegistryPrimer registryPrimer) {
        this.registryPrimer = registryPrimer;
    }

    public SourceModelBuildingContextProvider getExplicitContextProvider() {
        return this.explicitContextProvider;
    }

    public void setExplicitContextProvider(SourceModelBuildingContextProvider explicitContextProvider) {
        this.explicitContextProvider = explicitContextProvider;
    }

    public SourceModelBuildingContext bootstrap() {
        Collection<SourceModelBuildingContextProvider> discoveredProviders;
        if (this.explicitContextProvider != null) {
            SourceModelBuildingContext context = this.explicitContextProvider.produceContext(this.classLoading, this.registryPrimer, this.configValues);
            if (context != null) {
                return context;
            }
            ModelsLogging.MODELS_LOGGER.debugf("Explicit SourceModelBuildingContextProvider returned null", new Object[0]);
        }
        if ((discoveredProviders = this.classLoading.loadJavaServices(SourceModelBuildingContextProvider.class)).size() > 1) {
            ModelsLogging.MODELS_LOGGER.debugf("Multiple SourceModelBuildingContextProvider impls found", new Object[0]);
        }
        for (SourceModelBuildingContextProvider provider : discoveredProviders) {
            SourceModelBuildingContext context = provider.produceContext(this.classLoading, this.registryPrimer, this.configValues);
            if (context == null) continue;
            return context;
        }
        return new BasicModelBuildingContextImpl(this.classLoading, this.registryPrimer);
    }
}

