/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.models.UnknownClassException;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ModelsContext;

public abstract class AbstractClassDetailsRegistry
implements MutableClassDetailsRegistry {
    protected final ModelsContext context;
    protected final Map<String, ClassDetails> classDetailsMap;
    protected final Map<String, List<ClassDetails>> subTypeClassDetailsMap;

    protected AbstractClassDetailsRegistry(ModelsContext context) {
        this(new ConcurrentHashMap<String, ClassDetails>(), new ConcurrentHashMap<String, List<ClassDetails>>(), context);
    }

    protected AbstractClassDetailsRegistry(Map<String, ClassDetails> classDetailsMap, Map<String, List<ClassDetails>> subTypeClassDetailsMap, ModelsContext context) {
        this.classDetailsMap = classDetailsMap;
        this.subTypeClassDetailsMap = subTypeClassDetailsMap;
        this.context = context;
        classDetailsMap.put(ClassDetails.CLASS_CLASS_DETAILS.getName(), ClassDetails.CLASS_CLASS_DETAILS);
        classDetailsMap.put(ClassDetails.OBJECT_CLASS_DETAILS.getClassName(), ClassDetails.OBJECT_CLASS_DETAILS);
        classDetailsMap.put(ClassDetails.VOID_CLASS_DETAILS.getClassName(), ClassDetails.VOID_CLASS_DETAILS);
        classDetailsMap.put(ClassDetails.VOID_OBJECT_CLASS_DETAILS.getClassName(), ClassDetails.VOID_OBJECT_CLASS_DETAILS);
    }

    @Override
    public List<ClassDetails> getDirectSubTypes(String superTypeName) {
        return this.subTypeClassDetailsMap.get(superTypeName);
    }

    @Override
    public void forEachDirectSubType(String superTypeName, ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        List<ClassDetails> directSubTypes = this.getDirectSubTypes(superTypeName);
        if (directSubTypes == null) {
            return;
        }
        for (int i = 0; i < directSubTypes.size(); ++i) {
            consumer.consume(directSubTypes.get(i));
        }
    }

    @Override
    public ClassDetails findClassDetails(String name) {
        return this.classDetailsMap.get(name);
    }

    @Override
    public void forEachClassDetails(ClassDetailsRegistry.ClassDetailsConsumer consumer) {
        for (Map.Entry<String, ClassDetails> entry : this.classDetailsMap.entrySet()) {
            consumer.consume(entry.getValue());
        }
    }

    @Override
    public ClassDetails resolveClassDetails(String name) {
        if (name == null) {
            throw new IllegalArgumentException("`name` cannot be null");
        }
        ClassDetails existing = this.classDetailsMap.get(name);
        if (existing != null) {
            return existing;
        }
        return this.createClassDetails(name);
    }

    protected ClassDetails createClassDetails(String name) {
        try {
            ClassDetails created = this.getClassDetailsBuilder().buildClassDetails(name, this.context);
            this.addClassDetails(name, created);
            return created;
        }
        catch (UnknownClassException e) {
            try {
                return this.getClassDetailsBuilder().buildClassDetails(name + ".package-info", this.context);
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    @Override
    public void addClassDetails(ClassDetails classDetails) {
        this.addClassDetails(classDetails.getClassName(), classDetails);
    }

    @Override
    public void addClassDetails(String name, ClassDetails classDetails) {
        this.classDetailsMap.put(name, classDetails);
        if (classDetails.getSuperClass() != null) {
            List<ClassDetails> subTypes = this.subTypeClassDetailsMap.get(classDetails.getSuperClass().getName());
            if (subTypes == null) {
                subTypes = new ArrayList<ClassDetails>();
                this.subTypeClassDetailsMap.put(classDetails.getSuperClass().getName(), subTypes);
            }
            subTypes.add(classDetails);
        }
    }

    @Override
    public ClassDetails resolveClassDetails(String name, MutableClassDetailsRegistry.ClassDetailsCreator creator) {
        if (name == null) {
            throw new IllegalArgumentException("`name` cannot be null");
        }
        if ("void".equals(name)) {
            return null;
        }
        ClassDetails existing = this.classDetailsMap.get(name);
        if (existing != null) {
            return existing;
        }
        return this.createClassDetails(name, creator);
    }

    protected ClassDetails createClassDetails(String name, MutableClassDetailsRegistry.ClassDetailsCreator creator) {
        try {
            ClassDetails created = creator.createClassDetails(name);
            this.addClassDetails(name, created);
            return created;
        }
        catch (UnknownClassException e) {
            try {
                return creator.createClassDetails(name + ".package-info");
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    public Map<String, ClassDetails> classDetailsMap() {
        return this.classDetailsMap;
    }

    public Map<String, ClassDetails> getClassDetailsMap() {
        return Collections.unmodifiableMap(this.classDetailsMap);
    }

    public Map<String, List<ClassDetails>> getSubTypeClassDetailsMap() {
        return Collections.unmodifiableMap(this.subTypeClassDetailsMap);
    }
}

