/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.infinispan.InfinispanDialect;
import org.hibernate.ogm.datastore.infinispan.configuration.impl.InfinispanConfiguration;
import org.hibernate.ogm.datastore.infinispan.impl.CacheInitializer;
import org.hibernate.ogm.datastore.infinispan.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispan.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.counter.SequenceClusteredCounterHandler;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.counter.TableClusteredCounterHandler;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.ExternalizersIntegration;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.PersistenceStrategy;
import org.hibernate.ogm.datastore.keyvalue.options.CacheMappingType;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanEmbeddedDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private JtaPlatform jtaPlatform;
    private JndiService jndiService;
    private EmbeddedCacheManager externalCacheManager;
    private final InfinispanConfiguration config = new InfinispanConfiguration();
    private PersistenceStrategy<?, ?, ?> persistenceStrategy;
    private TableClusteredCounterHandler tableClusterHandler;
    private Map<String, SequenceClusteredCounterHandler> sequenceCounterHandlers = new HashMap<String, SequenceClusteredCounterHandler>();

    public Class<? extends GridDialect> getDefaultDialect() {
        return InfinispanDialect.class;
    }

    public void start() {
        try {
            String jndiProperty = this.config.getJndiName();
            if (jndiProperty != null) {
                LOG.tracef("Retrieving Infinispan from JNDI at %1$s", jndiProperty);
                this.externalCacheManager = (EmbeddedCacheManager)this.jndiService.locate(jndiProperty);
            }
        }
        catch (RuntimeException e) {
            throw LOG.unableToInitializeInfinispan(e);
        }
        if (this.externalCacheManager != null) {
            ExternalizersIntegration.validateExternalizersPresent(this.externalCacheManager);
        }
        this.jndiService = null;
    }

    public void initializePersistenceStrategy(CacheMappingType cacheMappingType, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes, Iterable<Namespace> namespaces) {
        this.persistenceStrategy = PersistenceStrategy.getInstance(cacheMappingType, this.externalCacheManager, this.config.getConfigurationUrl(), this.jtaPlatform, entityTypes, associationTypes, idSourceTypes);
        boolean requiresCounter = this.hasIdGeneration(idSourceTypes);
        if (requiresCounter) {
            this.tableClusterHandler = new TableClusteredCounterHandler(this.persistenceStrategy.getCacheManager().getCacheManager());
        }
        for (Namespace namespace : namespaces) {
            for (Sequence seq : namespace.getSequences()) {
                this.sequenceCounterHandlers.put(seq.getExportIdentifier(), new SequenceClusteredCounterHandler(this.persistenceStrategy.getCacheManager().getCacheManager(), seq));
            }
        }
        this.externalCacheManager = null;
        this.jtaPlatform = null;
    }

    private boolean hasIdGeneration(Set<IdSourceKeyMetadata> idSourceKeys) {
        for (IdSourceKeyMetadata idSourceKeyMetadata : idSourceKeys) {
            if (idSourceKeyMetadata.getType() != IdSourceKeyMetadata.IdSourceType.TABLE) continue;
            return true;
        }
        return false;
    }

    public LocalCacheManager<?, ?, ?> getCacheManager() {
        return this.persistenceStrategy.getCacheManager();
    }

    public KeyProvider<?, ?, ?> getKeyProvider() {
        return this.persistenceStrategy.getKeyProvider();
    }

    public void stop() {
        if (this.persistenceStrategy != null) {
            this.persistenceStrategy.getCacheManager().stop();
        }
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.jtaPlatform = (JtaPlatform)serviceRegistry.getService(JtaPlatform.class);
        this.jndiService = (JndiService)serviceRegistry.getService(JndiService.class);
    }

    public void configure(Map configurationValues) {
        this.config.initConfiguration(configurationValues);
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return CacheInitializer.class;
    }

    public Number nextValue(NextValueRequest request) {
        if (request.getKey().getMetadata().getType().equals((Object)IdSourceKeyMetadata.IdSourceType.TABLE)) {
            return this.tableClusterHandler.nextValue(request);
        }
        return this.sequenceCounterHandlers.get(request.getKey().getTable()).nextValue(request);
    }
}

