/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.ogm.datastore.infinispan.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispan.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.storedprocedure.ProcedureQueryParameters;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.ReflectionHelper;
import org.hibernate.ogm.util.impl.TupleExtractor;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.function.SerializableFunction;

public class InfinispanEmbeddedStoredProceduresManager {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final String STORED_PROCEDURES_CACHE_NAME = "___stored_procedures";

    public ClosableIterator<Tuple> callStoredProcedure(EmbeddedCacheManager embeddedCacheManager, String storedProcedureName, ProcedureQueryParameters queryParameters, ClassLoaderService classLoaderService) {
        this.validate(queryParameters);
        Cache cache = embeddedCacheManager.getCache(STORED_PROCEDURES_CACHE_NAME, true);
        String className = (String)cache.getOrDefault((Object)storedProcedureName, (Object)storedProcedureName);
        Callable<?> callable = InfinispanEmbeddedStoredProceduresManager.instantiate(storedProcedureName, className, classLoaderService);
        InfinispanEmbeddedStoredProceduresManager.setParams(storedProcedureName, queryParameters, callable);
        Object res = this.execute(storedProcedureName, embeddedCacheManager, callable);
        return this.extractResultSet(storedProcedureName, res);
    }

    private void validate(ProcedureQueryParameters queryParameters) {
        List positionalParameters = queryParameters.getPositionalParameters();
        if (positionalParameters != null && positionalParameters.size() > 0) {
            throw log.dialectDoesNotSupportPositionalParametersForStoredProcedures(this.getClass());
        }
    }

    private Object execute(String storedProcedureName, EmbeddedCacheManager embeddedCacheManager, Callable<?> callable) {
        AtomicReference ref = new AtomicReference();
        try {
            return ((CompletableFuture)embeddedCacheManager.executor().submitConsumer((SerializableFunction & Serializable)ecm -> InfinispanEmbeddedStoredProceduresManager.execute(storedProcedureName, callable), (a, r, e) -> {
                if (e != null) {
                    if (e instanceof HibernateException) {
                        throw (HibernateException)e;
                    }
                    throw log.cannotExecuteStoredProcedure(storedProcedureName, (Throwable)e);
                }
                ref.compareAndSet(null, r);
            }).thenCompose(v -> CompletableFuture.supplyAsync(ref::get))).get();
        }
        catch (Exception e2) {
            throw log.cannotExecuteStoredProcedure(storedProcedureName, e2);
        }
    }

    private static Callable<?> instantiate(String storedProcedureName, String className, ClassLoaderService classLoaderService) {
        try {
            Class clazz = classLoaderService.classForName(className);
            return (Callable)clazz.newInstance();
        }
        catch (ClassLoadingException e) {
            throw log.procedureWithResolvedNameDoesNotExist(className, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw log.cannotInstantiateStoredProcedure(storedProcedureName, className, e);
        }
    }

    private static void setParams(String storedProcedureName, ProcedureQueryParameters queryParameters, Callable<?> callable) {
        Map params = queryParameters.getNamedParameters();
        for (Map.Entry entry : params.entrySet()) {
            try {
                ReflectionHelper.setField(callable, (String)((String)entry.getKey()), entry.getValue());
            }
            catch (Exception e) {
                throw log.cannotSetStoredProcedureParameter(storedProcedureName, (String)entry.getKey(), entry.getValue(), e);
            }
        }
    }

    private static Object execute(String storedProcedureName, Callable<?> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw log.cannotExecuteStoredProcedure(storedProcedureName, e);
        }
    }

    private ClosableIterator<Tuple> extractResultSet(String storedProcedureName, Object res) {
        try {
            return CollectionHelper.newClosableIterator((Iterable)TupleExtractor.extractTuplesFromObject((Object)res));
        }
        catch (Exception e) {
            throw log.cannotExtractStoredProcedureResultSet(storedProcedureName, res, e);
        }
    }
}

