/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.dialect.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.hibernate.ogm.grid.IdSourceKey;
import org.hibernate.ogm.grid.IdSourceKeyMetadata;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class IdSourceKeyExternalizer
implements AdvancedExternalizer<IdSourceKey> {
    public static final IdSourceKeyExternalizer INSTANCE = new IdSourceKeyExternalizer();
    private static final int VERSION = 1;
    private static final Set<Class<? extends IdSourceKey>> TYPE_CLASSES = Collections.singleton(IdSourceKey.class);

    private IdSourceKeyExternalizer() {
    }

    public void writeObject(ObjectOutput output, IdSourceKey key) throws IOException {
        output.writeInt(1);
        output.writeUTF(key.getTable());
        output.writeObject(key.getColumnNames());
        output.writeObject(key.getColumnValues());
    }

    public IdSourceKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        input.readInt();
        String tableName = input.readUTF();
        String[] columnNames = (String[])input.readObject();
        Object[] values = (Object[])input.readObject();
        IdSourceKeyMetadata metadata = IdSourceKeyMetadata.forTable((String)tableName, (String)columnNames[0], null);
        return IdSourceKey.forTable((IdSourceKeyMetadata)metadata, (String)((String)values[0]));
    }

    public Set<Class<? extends IdSourceKey>> getTypeClasses() {
        return TYPE_CLASSES;
    }

    public Integer getId() {
        return 1404;
    }
}

