/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.infinispan.impl.TransactionManagerLookupDelegator;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

public abstract class LocalCacheManager<EK, AK, ISK> {
    private final EmbeddedCacheManager cacheManager;
    private final boolean isProvidedCacheManager;

    protected LocalCacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.isProvidedCacheManager = true;
    }

    protected LocalCacheManager(URL configUrl, JtaPlatform platform, Set<String> cacheNames, KeyProvider<EK, AK, ISK> keyProvider) {
        this.cacheManager = LocalCacheManager.createCustomCacheManager(configUrl, platform, cacheNames, keyProvider);
        this.isProvidedCacheManager = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EmbeddedCacheManager createCustomCacheManager(URL configUrl, JtaPlatform platform, Set<String> cacheNames, KeyProvider<?, ?, ?> keyProvider) {
        DefaultCacheManager defaultCacheManager;
        block9: {
            TransactionManagerLookupDelegator transactionManagerLookupDelegator = new TransactionManagerLookupDelegator(platform);
            InputStream configurationFile = configUrl.openStream();
            try {
                DefaultCacheManager tmpCacheManager = new DefaultCacheManager(configurationFile, false);
                SerializationConfigurationBuilder serializationConfiguration = new GlobalConfigurationBuilder().read(tmpCacheManager.getCacheManagerConfiguration()).serialization();
                for (AdvancedExternalizer<?> externalizer : keyProvider.getExternalizers()) {
                    serializationConfiguration.addAdvancedExternalizer(externalizer.getId().intValue(), externalizer);
                }
                GlobalConfiguration globalConfiguration = serializationConfiguration.build();
                DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfiguration, false);
                for (String cacheName : cacheNames) {
                    Configuration originalCfg = tmpCacheManager.getCacheConfiguration(cacheName);
                    if (originalCfg == null) {
                        originalCfg = tmpCacheManager.getDefaultCacheConfiguration();
                    }
                    Configuration newCfg = new ConfigurationBuilder().read(originalCfg).transaction().transactionManagerLookup((TransactionManagerLookup)transactionManagerLookupDelegator).build();
                    cacheManager.defineConfiguration(cacheName, newCfg);
                }
                cacheManager.start();
                defaultCacheManager = cacheManager;
                if (configurationFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (configurationFile != null) {
                        configurationFile.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw LocalCacheManager.raiseConfigurationError(e, configUrl.toString());
                }
            }
            configurationFile.close();
        }
        return defaultCacheManager;
    }

    private static HibernateException raiseConfigurationError(Exception e, String cfgName) {
        return new HibernateException("Could not start Infinispan CacheManager using as configuration file: " + cfgName, (Throwable)e);
    }

    protected EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void stop() {
        if (!this.isProvidedCacheManager) {
            this.cacheManager.stop();
        }
    }

    public abstract Cache<EK, Map<String, Object>> getEntityCache(EntityKeyMetadata var1);

    public abstract Cache<AK, Map<RowKey, Map<String, Object>>> getAssociationCache(AssociationKeyMetadata var1);

    public abstract Cache<ISK, Object> getIdSourceCache(IdSourceKeyMetadata var1);

    public abstract Set<Bucket<EK>> getWorkBucketsFor(EntityKeyMetadata ... var1);

    public static class Bucket<EK> {
        private final Cache<EK, Map<String, Object>> cache;
        private final EntityKeyMetadata[] entityKeyMetadatas;

        public Bucket(Cache<EK, Map<String, Object>> cache, List<EntityKeyMetadata> entityKeyMetadatas) {
            this.cache = cache;
            this.entityKeyMetadatas = entityKeyMetadatas.toArray(new EntityKeyMetadata[entityKeyMetadatas.size()]);
        }

        public Bucket(Cache<EK, Map<String, Object>> cache, EntityKeyMetadata ... entityKeyMetadatas) {
            this.cache = cache;
            this.entityKeyMetadatas = entityKeyMetadatas;
        }

        public Cache<EK, Map<String, Object>> getCache() {
            return this.cache;
        }

        public EntityKeyMetadata[] getEntityKeyMetadata() {
            return this.entityKeyMetadatas;
        }
    }
}

