/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.impl;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.impl.OnePerKindKeyProvider;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;

public class OnePerKindCacheManager
extends LocalCacheManager<EntityKey, AssociationKey, IdSourceKey> {
    private static final Set<String> CACHE_NAMES = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{"ENTITIES", "ASSOCIATIONS", "IDENTIFIERS"}));
    private final Cache<EntityKey, Map<String, Object>> entityCache = this.getCacheManager().getCache("ENTITIES");
    private final Cache<AssociationKey, Map<RowKey, Map<String, Object>>> associationCache = this.getCacheManager().getCache("ASSOCIATIONS");
    private final Cache<IdSourceKey, Object> idSourceCache = this.getCacheManager().getCache("IDENTIFIERS");

    public OnePerKindCacheManager(EmbeddedCacheManager cacheManager) {
        super(cacheManager);
    }

    public OnePerKindCacheManager(URL configUrl, JtaPlatform platform, OnePerKindKeyProvider keyProvider) {
        super(configUrl, platform, CACHE_NAMES, keyProvider);
    }

    @Override
    public Cache<EntityKey, Map<String, Object>> getEntityCache(EntityKeyMetadata keyMetadata) {
        return this.entityCache;
    }

    @Override
    public Cache<AssociationKey, Map<RowKey, Map<String, Object>>> getAssociationCache(AssociationKeyMetadata keyMetadata) {
        return this.associationCache;
    }

    @Override
    public Cache<IdSourceKey, Object> getIdSourceCache(IdSourceKeyMetadata keyMetadata) {
        return this.idSourceCache;
    }

    @Override
    public Set<LocalCacheManager.Bucket<EntityKey>> getWorkBucketsFor(EntityKeyMetadata ... entityKeyMetadatas) {
        return Collections.singleton(new LocalCacheManager.Bucket<EntityKey>(this.entityCache, entityKeyMetadatas));
    }
}

