/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.ogm.datastore.infinispan.dialect.impl.InfinispanPessimisticWriteLockingStrategy;
import org.hibernate.ogm.datastore.infinispan.dialect.impl.InfinispanTupleSnapshot;
import org.hibernate.ogm.datastore.infinispan.impl.InfinispanDatastoreProvider;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.persister.entity.Lockable;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Reducer;

public class InfinispanDialect<EK, AK, ISK>
extends BaseGridDialect {
    private final InfinispanDatastoreProvider provider;

    public InfinispanDialect(InfinispanDatastoreProvider provider) {
        this.provider = provider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE) {
            return new InfinispanPessimisticWriteLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return new InfinispanPessimisticWriteLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        return null;
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        EK cacheKey = this.getKeyProvider().getEntityCacheKey(key);
        Cache<EK, Map<String, Object>> cache = this.getCacheManager().getEntityCache(key.getMetadata());
        return this.getTupleFromCacheKey(cacheKey, cache);
    }

    private Tuple getTupleFromCacheKey(EK cacheKey, Cache<EK, Map<String, Object>> cache) {
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache, cacheKey, (boolean)false);
        if (atomicMap == null) {
            return null;
        }
        return new Tuple((TupleSnapshot)new InfinispanTupleSnapshot((FineGrainedAtomicMap<String, Object>)atomicMap), Tuple.SnapshotType.UPDATE);
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        Cache<EK, Map<String, Object>> cache = this.getCacheManager().getEntityCache(key.getMetadata());
        EK cacheKey = this.getKeyProvider().getEntityCacheKey(key);
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache, cacheKey, (boolean)true);
        return new Tuple((TupleSnapshot)new InfinispanTupleSnapshot((FineGrainedAtomicMap<String, Object>)atomicMap), Tuple.SnapshotType.INSERT);
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        Tuple tuple = tuplePointer.getTuple();
        FineGrainedAtomicMap<String, Object> atomicMap = ((InfinispanTupleSnapshot)tuple.getSnapshot()).getAtomicMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, atomicMap);
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        Cache<EK, Map<String, Object>> cache = this.getCacheManager().getEntityCache(key.getMetadata());
        EK cacheKey = this.getKeyProvider().getEntityCacheKey(key);
        AtomicMapLookup.removeAtomicMap(cache, cacheKey);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        AK cacheKey;
        Cache<AK, Map<RowKey, Map<String, Object>>> cache = this.getCacheManager().getAssociationCache(key.getMetadata());
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache, cacheKey = this.getKeyProvider().getAssociationCacheKey(key), (boolean)false);
        return atomicMap == null ? null : new Association((AssociationSnapshot)new MapAssociationSnapshot((Map)atomicMap));
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<AK, Map<RowKey, Map<String, Object>>> cache = this.getCacheManager().getAssociationCache(key.getMetadata());
        AK cacheKey = this.getKeyProvider().getAssociationCacheKey(key);
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache, cacheKey, (boolean)true);
        return new Association((AssociationSnapshot)new MapAssociationSnapshot((Map)atomicMap));
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        MapHelpers.updateAssociation((Association)association);
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<AK, Map<RowKey, Map<String, Object>>> cache = this.getCacheManager().getAssociationCache(key.getMetadata());
        AK cacheKey = this.getKeyProvider().getAssociationCacheKey(key);
        AtomicMapLookup.removeAtomicMap(cache, cacheKey);
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        Long newValue;
        Number value;
        boolean done;
        AdvancedCache identifierCache = this.getCacheManager().getIdSourceCache(request.getKey().getMetadata()).getAdvancedCache();
        ISK cacheKey = this.getKeyProvider().getIdSourceCacheKey(request.getKey());
        do {
            Number oldValue;
            if ((value = (Number)identifierCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get(cacheKey)) != null || (oldValue = (Number)identifierCache.putIfAbsent(cacheKey, (Object)(value = Long.valueOf(request.getInitialValue())))) == null) continue;
            value = oldValue;
        } while (!(done = identifierCache.replace(cacheKey, (Object)value, (Object)(newValue = Long.valueOf(value.longValue() + (long)request.getIncrement())))));
        return value;
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        Set<LocalCacheManager.Bucket<EK>> buckets = this.getCacheManager().getWorkBucketsFor(entityKeyMetadata);
        for (LocalCacheManager.Bucket<EK> bucket : buckets) {
            Map<EK, Map<String, Object>> queryResult = this.retrieveKeys(bucket.getCache(), bucket.getEntityKeyMetadata());
            for (Map.Entry<EK, Map<String, Object>> entry : queryResult.entrySet()) {
                consumer.consume(this.getTupleFromCacheKey(entry.getKey(), bucket.getCache()));
            }
        }
    }

    private Map<EK, Map<String, Object>> retrieveKeys(Cache<EK, Map<String, Object>> cache, EntityKeyMetadata ... entityKeyMetadatas) {
        MapReduceTask queryTask = new MapReduceTask(cache);
        queryTask.mappedWith(this.getKeyProvider().getMapper(entityKeyMetadatas)).reducedWith(new TupleReducer());
        return queryTask.execute();
    }

    private LocalCacheManager<EK, AK, ISK> getCacheManager() {
        return this.provider.getCacheManager();
    }

    private KeyProvider<EK, AK, ISK> getKeyProvider() {
        return this.provider.getKeyProvider();
    }

    static class TupleReducer<EK>
    implements Reducer<EK, Map<String, Object>> {
        TupleReducer() {
        }

        public Map<String, Object> reduce(EK reducedKey, Iterator<Map<String, Object>> iter) {
            return iter.next();
        }
    }
}

