/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl;

import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.EntityKey;

public class PersistentEntityKey {
    private final String[] columnNames;
    private final Object[] columnValues;

    public PersistentEntityKey(String[] columnNames, Object[] columnValues) {
        this.columnNames = columnNames;
        this.columnValues = columnValues;
    }

    public static PersistentEntityKey fromEntityKey(EntityKey key) {
        return new PersistentEntityKey(key.getColumnNames(), key.getColumnValues());
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnNames);
        result = 31 * result + Arrays.hashCode(this.columnValues);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentEntityKey other = (PersistentEntityKey)obj;
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        return Arrays.equals(this.columnValues, other.columnValues);
    }

    public String toString() {
        return "PersistentEntityKey [columnNames=" + Arrays.toString(this.columnNames) + ", columnValues=" + Arrays.toString(this.columnValues) + "]";
    }
}

