/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.infinispan.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispan.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.common.externalizer.impl.RowKeyExternalizer;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.externalizer.impl.AssociationKeyExternalizer;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.externalizer.impl.EntityKeyExternalizer;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.externalizer.impl.EntityKeyMetadataExternalizer;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.externalizer.impl.IdSourceKeyExternalizer;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentAssociationKeyExternalizer;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentEntityKeyExternalizer;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentIdSourceKeyExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public final class ExternalizersIntegration {
    private static final Log log = LoggerFactory.getLogger();
    private static final Map<Integer, AdvancedExternalizer<?>> ogmExternalizers = ExternalizersIntegration.initializeOgmExternalizers();

    private ExternalizersIntegration() {
    }

    private static Map<Integer, AdvancedExternalizer<?>> initializeOgmExternalizers() {
        HashMap m = new HashMap();
        ExternalizersIntegration.addExternalizerToMap(m, AssociationKeyExternalizer.INSTANCE);
        ExternalizersIntegration.addExternalizerToMap(m, EntityKeyExternalizer.INSTANCE);
        ExternalizersIntegration.addExternalizerToMap(m, EntityKeyMetadataExternalizer.INSTANCE);
        ExternalizersIntegration.addExternalizerToMap(m, IdSourceKeyExternalizer.INSTANCE);
        ExternalizersIntegration.addExternalizerToMap(m, PersistentAssociationKeyExternalizer.INSTANCE);
        ExternalizersIntegration.addExternalizerToMap(m, PersistentEntityKeyExternalizer.INSTANCE);
        ExternalizersIntegration.addExternalizerToMap(m, PersistentIdSourceKeyExternalizer.INSTANCE);
        ExternalizersIntegration.addExternalizerToMap(m, RowKeyExternalizer.INSTANCE);
        return Collections.unmodifiableMap(m);
    }

    private static void addExternalizerToMap(Map<Integer, AdvancedExternalizer<?>> m, AdvancedExternalizer<?> instance) {
        Integer id = instance.getId();
        assert (id != null);
        assert (id >= 1400 && id < 1500) : "Externalizer out of the assigned range for Hibernate OGM";
        AdvancedExternalizer<?> previous = m.put(instance.getId(), instance);
        assert (previous == null) : "Clash in Externalizer Id! They need to be strictly unique.";
    }

    public static void registerOgmExternalizers(SerializationConfigurationBuilder cfg) {
        for (AdvancedExternalizer<?> advancedExternalizer : ogmExternalizers.values()) {
            cfg.addAdvancedExternalizer(advancedExternalizer);
        }
    }

    public static void registerOgmExternalizers(GlobalConfiguration globalCfg) {
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.putAll(ogmExternalizers);
    }

    public static void validateExternalizersPresent(EmbeddedCacheManager externalCacheManager) {
        Map externalizerMap = externalCacheManager.getCacheManagerConfiguration().serialization().advancedExternalizers();
        for (AdvancedExternalizer<?> ogmExternalizer : ogmExternalizers.values()) {
            Integer externalizerId = ogmExternalizer.getId();
            AdvancedExternalizer registeredExternalizer = (AdvancedExternalizer)externalizerMap.get(externalizerId);
            if (registeredExternalizer == null) {
                throw log.externalizersNotRegistered(externalizerId, ogmExternalizer.getClass());
            }
            if (registeredExternalizer.getClass().equals(ogmExternalizer)) continue;
            if (registeredExternalizer.getClass().toString().equals(ogmExternalizer.getClass().toString())) {
                throw log.registeredExternalizerNotLoadedFromOGMClassloader(registeredExternalizer.getClass());
            }
            throw log.externalizerIdNotMatchingType(externalizerId, registeredExternalizer, ogmExternalizer);
        }
    }
}

