/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.logging.impl;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.persistence.PersistenceException;
import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransactionException;
import org.hibernate.ogm.datastore.infinispan.logging.impl.Log;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.exception.EntityAlreadyExistsException;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.options.spi.AnnotationConverter;
import org.hibernate.ogm.util.impl.ClassObjectFormatter;
import org.hibernate.service.spi.ServiceException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
org.hibernate.ogm.util.impl.Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String unexpectedKeyVersion = "OGM001101: Cannot unmarshal key of type %1$s written by a newer version of Hibernate OGM. Expecting version %3$s but found version %2$s.";
    private static final String unableToInitializeInfinispan = "OGM001102: Unable to find or initialize Infinispan CacheManager";
    private static final String externalizersNotRegistered = "OGM001103: Infinispan Externalizer having id [%d] not registered in CacheManager. This Externalizer is required and included in Hibernate OGM as '%2$s': if you provide a CacheManager make sure it canauto-discover extension points from Hibernate OGM before starting.";
    private static final String registeredExternalizerNotLoadedFromOGMClassloader = "OGM001104: Infinispan Externalizer '%s' was registered but apparently loaded from the wrong module. Aborting as a version mismatch could corrupt stored data.";
    private static final String externalizerIdNotMatchingType = "OGM001105: Infinispan Externalizer mistmatch: id [%1$d] was registered but taken by implementation '%2$s'. Expected externalizer: '%3$s' ";
    private static final String missingCacheConfiguration = "OGM001106: Missing configuration for cache '%1$s' and a default configuration was not provided";
    private static final String clusteringHashGroupsMustBeEnabled = "OGM001107: The Infinispan dialect uses fine grained maps: `clustering.hash.groups` must be enabled. `clustering.hash.groups` is now enabled for cache `%1$s`. Enable this property explicitly in your configuration to resolve this warning.";
    private static final String version = "OGM000001: Hibernate OGM %1$s";
    private static final String persistenceXmlNotFoundInClassPath = "OGM000002: Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s";
    private static final String cannotInstantiateGridDialect = "OGM000011: Cannot instantiate GridDialect class [%1$s]";
    private static final String gridDialectHasNoProperConstructor = "OGM000014: %1$s has no constructor accepting org.hibernate.ogm.datastore.spi.DatastoreProvider";
    private static final String unexpectedDatastoreProvider = "OGM000015: Expected DatastoreProvider %2$s but found %1$s";
    private static final String useDatastoreProvider = "OGM000016: NoSQL Datastore provider: %1$s";
    private static final String useGridDialect = "OGM000017: Grid Dialect: %1$s";
    private static final String jtaTransactionBeginFailed = "OGM000018: JTA transaction begin failed";
    private static final String jtaCommitFailed = "OGM000019: JTA transaction commit failed";
    private static final String jtaRollbackFailed = "OGM000020: JTA transaction rollback failed";
    private static final String unableToMarkTransactionForRollback = "OGM000021: Unable to mark JTA transaction for rollback";
    private static final String jtaCouldNotDetermineStatus = "OGM000022: Could not determine transaction status";
    private static final String unableToSetTimeout = "OGM000023: Unable to set transaction timeout to '%1$s'";
    private static final String querySyntaxException = "OGM000024: Syntax error in query: [%1$s]";
    private static final String interruptedBatchIndexing = "OGM000025: Batch indexing was interrupted";
    private static final String illegalDiscrimantorType = "OGM000026: Illegal discriminator type: '%1$s'";
    private static final String unableToConvertStringToDiscriminator = "OGM000027: Could not convert string to discriminator object";
    private static final String createdQuery = "OGM000028: Created query object '%2$s' from HQL/JP-QL query '%1$s'.";
    private static final String unsupportedIndexerConfigurationOption = "OGM000031: OgmMassIndexer doesn't support the configuration option '%s'. Its setting will be ignored.";
    private static final String mappingSubtypeNotInterface = "OGM000032: Unable to support mapping subtypes that are not interfaces: %1$s";
    private static final String cannotCreateNewProxyInstance = "OGM000033: Unable to create new proxy instance";
    private static final String cannotConvertAnnotation = "OGM000034: Annotation cannot be converted using %1$s";
    private static final String unableToLoadContext = "OGM000036: Unable to load %1$s method from %2$s ";
    private static final String cannotCreateGlobalContextProxy = "OGM000037: Unable to create global context proxy for type %1$s";
    private static final String cannotCreateEntityContextProxy = "OGM000038: Unable to create entity context proxy for type %1$s";
    private static final String cannotCreatePropertyContextProxy = "OGM000039: Unable to create property context proxy for type %1$s";
    private static final String getPropertyDoesNotExistException = "OGM000041: The given propery %1$s#%2$s with element type %3$s does not exist.";
    private static final String getUnsupportedElementTypeException = "OGM000042: The given element type %1$s is neither FIELD nor METHOD.";
    private static final String unableToInstantiateType = "OGM000043: Cannot instantiate type %1$s. Does it define a default constructor?";
    private static final String unableToLoadClass = "OGM000044: Cannot load class %2$s specified via configuration property '%1$s'";
    private static final String unexpectedClassType = "OGM000045: Type %2$s specified via configuration property '%1$s' is not a sub-type of expected type %3$s";
    private static final String unexpectedInstanceType = "OGM000046: Object %2$s of type %3$s specified via configuration property '%1$s' is not of the expected type %4$s";
    private static final String ambigiousOptionConfiguration = "OGM000047: Either an option configurator may be specified via configuration property '%1$s' or OgmConfiguration#configureOptions() may be called, but not both at the same time.";
    private static final String unknownAssociationStorageStrategy = "OGM000048: Unknown association storage strategy: [%s]. Supported values are: %s";
    private static final String illegalPortValue = "OGM000049: The value set for the configuration property 'hibernate.ogm.datastore.port' must be a number between 1 and 65535. Found '%s'.";
    private static final String notAnInteger = "OGM000050: The value set for the configuration property '%1$s' must be an integer number. Found '%2$s'.";
    private static final String unknownEnumerationValue = "OGM000051: Unknown value given for configuration property '%1$s'; Found '%2$s', but supported values are: %3$s";
    private static final String missingConfigurationProperty = "OGM000052: Missing value for property '%s'";
    private static final String unsupportedPropertyType = "OGM000053: Value of unsupported type given for configuration property '%1$s': '%2$s'";
    private static final String closedOperationQueue = "OGM000054: It is not possible to add or poll operations from a closed queue";
    private static final String invalidConfigurationUrl = "OGM000055: Invalid URL given for configuration property '%1$s': %2$s; The specified resource could not be found.";
    private static final String couldNotRetrieveEntityForRetrievalOfGeneratedProperties = "OGM000056: Unable to load record for retrieval of generated properties; Entity type: %1$s, id: %2$s";
    private static final String mustNotBeNull = "OGM000057: '%s' must not be null";
    private static final String parameterMustNotBeNull = "OGM000058: Parameter '%s' must not be null";
    private static final String unableToFindGridType = "OGM000059: Unable to find a GridType for %s";
    private static final String dialectDoesNotSupportSequences = "OGM000060: Sequence id generator used for entity '%2$s' is not supported by grid dialect %1$s, falling back to table-based id generation. Consider to use @TableGenerator rather than @SequenceGenerator.";
    private static final String catalogOptionNotSupportedForTableGenerator = "OGM000061: The option '@TableGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String schemaOptionNotSupportedForTableGenerator = "OGM000062: The option '@TableGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String catalogOptionNotSupportedForSequenceGenerator = "OGM000063: The option '@SequenceGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String schemaOptionNotSupportedForSequenceGenerator = "OGM000064: The option '@SequenceGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String getIdentityGenerationStrategyNotSupportedException = "OGM000065: Id generation strategy IDENTITY configured for entity %1$s is not supported by the current grid dialect.";
    private static final String usingNonAtomicOptimisticLocking = "OGM000066: Entity type %s uses an optimistic locking strategy which is not supported by the current grid dialect in an atomic manner. There will be two datastore round-trips for version checking and updating the data.";
    private static final String mustNotInsertSameEntityTwice = "OGM000067: Trying to insert an already existing entity: %s";
    private static final String couldNotConfigureProperty = "OGM000068: Could not configure property %1$s#%2$s";
    private static final String unsupportedLockMode = "OGM000069: Grid dialect %1$s does not support lock mode %2$s";
    private static final String noValidDatastoreProviderShortName = "OGM000070: '%1$s' is no valid datastore provider short name. Valid values are: %2$s";
    private static final String unableToStartDatastoreProvider = "OGM000071: Unable to start datastore provider";
    private static final String unableToConfigureDatastoreProvider = "OGM000072: Unable to configure datastore provider";
    private static final String cannotLoadLuceneParserBackend = "OGM000073: Couldn't load the Lucene-based query parser backend. Make sure the dependency org.hibernate.hql:hibernate-hql-lucene is part of the classpath.";
    private static final String unableToCloseSessionButSwallowingError = "OGM000074: Could not close session; swallowing exception as transaction completed";
    private static final String jbossTransactionManagerDetected = "OGM000075: JBoss Transaction Manager (com.arjuna.ats.jta.TransactionManager) detected on classpath. Using JBossStandAloneJtaPlatform as JTAPlatform implementation";
    private static final String noJtaPlatformDetected = "OGM000076: No explicit or implicit defined JTAPlatform. Using NoJtaPlatform";
    private static final String parameterSringMustNotBeEmpty = "OGM000077: Parameter '%s' must not be an empty string";
    private static final String getUnknownAliasException = "OGM000078: Unrecognized alias in query:  %s";
    private static final String unableToParseHost = "OGM000079: Unable to parse hibernate.ogm.datastore.host %s\nProperty should be a comma separated list of host:port\ne.g. www.example.com, www2.example.com:123, 192.0.2.1, 192.0.2.2:123, 2001:db8::ff00:42:8329, [2001:db8::ff00:42:8329]:123";
    private static final String errorOnEntityBatchLoad = "OGM000080: Could not load an entity batch: %s";
    private static final String notALong = "OGM000081: The value set for the configuration property '%1$s' must be a long number. Found '%2$s'.";
    private static final String entityTupleNotFound = "OGM000082: The entity at the inverse side of the association '%1$s' cannot be found in the session: %2$s";
    private static final String failureWhenUsingAttributeConverter = "OGM000083: Failure when using JPA AttributeConverter [%1$s]. Is the datastore type of the converter a supported type for your datastore?";
    private static final String cannotFindTypeForAttributeConverter = "OGM000084: Unable to find basic type support for [%2$s] when using JPA AttributeConverter [%1$s].Is the datastore type of the converter a supported type for your datastore?";
    private static final String cannotFindEntityEntryForEntity = "OGM000085: Unable to find an entity entry for the entity '%1$s'";
    private static final String transactionIdIsNotAvailable = "OGM000086: Transaction identifier not available";
    private static final String tupleContextNotAvailable = "OGM000087: The tuple context is not available, probably because we are dealing with more than a single entity type";
    private static final String usingDeprecatedDatastoreProviderName = "OGM000088: Configuration is referring to deprecated datastore provider name '%1$s'. Please use the new form '%2$s' instead.";
    private static final String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass = "OGM000089: %1$s does not support queries on polymorphic entities using TABLE_PER_CLASS inheritance strategy. You should try using SINGLE_TABLE instead. Entities: %2$s";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unexpectedKeyVersion$str() {
        return unexpectedKeyVersion;
    }

    @Override
    public final HibernateException unexpectedKeyVersion(Class<?> clazz, int version, int supportedVersion) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedKeyVersion$str(), clazz, version, supportedVersion));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeInfinispan$str() {
        return unableToInitializeInfinispan;
    }

    @Override
    public final ServiceException unableToInitializeInfinispan(RuntimeException e) {
        ServiceException result = new ServiceException(String.format(this.getLoggingLocale(), this.unableToInitializeInfinispan$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String externalizersNotRegistered$str() {
        return externalizersNotRegistered;
    }

    @Override
    public final HibernateException externalizersNotRegistered(Integer externalizerId, Class<?> aClass) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.externalizersNotRegistered$str(), externalizerId, aClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String registeredExternalizerNotLoadedFromOGMClassloader$str() {
        return registeredExternalizerNotLoadedFromOGMClassloader;
    }

    @Override
    public final HibernateException registeredExternalizerNotLoadedFromOGMClassloader(Class<? extends AdvancedExternalizer> aClass) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.registeredExternalizerNotLoadedFromOGMClassloader$str(), aClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String externalizerIdNotMatchingType$str() {
        return externalizerIdNotMatchingType;
    }

    @Override
    public final HibernateException externalizerIdNotMatchingType(Integer externalizerId, AdvancedExternalizer<?> registeredExternalizer, AdvancedExternalizer expectedExternalizer) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.externalizerIdNotMatchingType$str(), externalizerId, registeredExternalizer, expectedExternalizer));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCacheConfiguration$str() {
        return missingCacheConfiguration;
    }

    @Override
    public final HibernateException missingCacheConfiguration(String cacheName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.missingCacheConfiguration$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void clusteringHashGroupsMustBeEnabled(String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.clusteringHashGroupsMustBeEnabled$str(), (Object)cacheName);
    }

    protected String clusteringHashGroupsMustBeEnabled$str() {
        return clusteringHashGroupsMustBeEnabled;
    }

    public final void version(String arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)arg0);
    }

    protected String version$str() {
        return version;
    }

    public final void persistenceXmlNotFoundInClassPath(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.persistenceXmlNotFoundInClassPath$str(), (Object)arg0);
    }

    protected String persistenceXmlNotFoundInClassPath$str() {
        return persistenceXmlNotFoundInClassPath;
    }

    protected String cannotInstantiateGridDialect$str() {
        return cannotInstantiateGridDialect;
    }

    public final HibernateException cannotInstantiateGridDialect(Class<?> arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotInstantiateGridDialect$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gridDialectHasNoProperConstructor$str() {
        return gridDialectHasNoProperConstructor;
    }

    public final HibernateException gridDialectHasNoProperConstructor(Class<?> arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.gridDialectHasNoProperConstructor$str(), new ClassObjectFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedDatastoreProvider$str() {
        return unexpectedDatastoreProvider;
    }

    public final HibernateException unexpectedDatastoreProvider(Class<?> arg0, Class<?> arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedDatastoreProvider$str(), new ClassObjectFormatter(arg0), new ClassObjectFormatter(arg1)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void useDatastoreProvider(Class<?> arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.useDatastoreProvider$str(), (Object)new ClassObjectFormatter(arg0));
    }

    protected String useDatastoreProvider$str() {
        return useDatastoreProvider;
    }

    public final void useGridDialect(Class<?> arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.useGridDialect$str(), (Object)new ClassObjectFormatter(arg0));
    }

    protected String useGridDialect$str() {
        return useGridDialect;
    }

    protected String jtaTransactionBeginFailed$str() {
        return jtaTransactionBeginFailed;
    }

    public final TransactionException jtaTransactionBeginFailed(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaTransactionBeginFailed$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCommitFailed$str() {
        return jtaCommitFailed;
    }

    public final TransactionException jtaCommitFailed(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaCommitFailed$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaRollbackFailed$str() {
        return jtaRollbackFailed;
    }

    public final TransactionException jtaRollbackFailed(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaRollbackFailed$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToMarkTransactionForRollback$str() {
        return unableToMarkTransactionForRollback;
    }

    public final TransactionException unableToMarkTransactionForRollback(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.unableToMarkTransactionForRollback$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCouldNotDetermineStatus$str() {
        return jtaCouldNotDetermineStatus;
    }

    public final TransactionException jtaCouldNotDetermineStatus(SystemException arg0) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaCouldNotDetermineStatus$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetTimeout$str() {
        return unableToSetTimeout;
    }

    public final TransactionException unableToSetTimeout(SystemException arg0, int arg1) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.unableToSetTimeout$str(), arg1), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String querySyntaxException$str() {
        return querySyntaxException;
    }

    public final HibernateException querySyntaxException(Exception arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.querySyntaxException$str(), arg1), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    protected String illegalDiscrimantorType$str() {
        return illegalDiscrimantorType;
    }

    public final HibernateException illegalDiscrimantorType(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.illegalDiscrimantorType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertStringToDiscriminator$str() {
        return unableToConvertStringToDiscriminator;
    }

    public final HibernateException unableToConvertStringToDiscriminator(Exception arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToConvertStringToDiscriminator$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void createdQuery(String arg0, Object arg1) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdQuery$str(), (Object)arg0, arg1);
    }

    protected String createdQuery$str() {
        return createdQuery;
    }

    public final void unsupportedIndexerConfigurationOption(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedIndexerConfigurationOption$str(), (Object)arg0);
    }

    protected String unsupportedIndexerConfigurationOption$str() {
        return unsupportedIndexerConfigurationOption;
    }

    protected String mappingSubtypeNotInterface$str() {
        return mappingSubtypeNotInterface;
    }

    public final HibernateException mappingSubtypeNotInterface(Class<?> arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.mappingSubtypeNotInterface$str(), new ClassObjectFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateNewProxyInstance$str() {
        return cannotCreateNewProxyInstance;
    }

    public final HibernateException cannotCreateNewProxyInstance(Exception arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreateNewProxyInstance$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertAnnotation$str() {
        return cannotConvertAnnotation;
    }

    public final HibernateException cannotConvertAnnotation(Class<? extends AnnotationConverter<?>> arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotConvertAnnotation$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadContext$str() {
        return unableToLoadContext;
    }

    public final HibernateException unableToLoadContext(String arg0, Class<?> arg1, Exception arg2) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToLoadContext$str(), arg0, new ClassObjectFormatter(arg1)), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateGlobalContextProxy$str() {
        return cannotCreateGlobalContextProxy;
    }

    public final HibernateException cannotCreateGlobalContextProxy(Class<?> arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreateGlobalContextProxy$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateEntityContextProxy$str() {
        return cannotCreateEntityContextProxy;
    }

    public final HibernateException cannotCreateEntityContextProxy(Class<?> arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreateEntityContextProxy$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreatePropertyContextProxy$str() {
        return cannotCreatePropertyContextProxy;
    }

    public final HibernateException cannotCreatePropertyContextProxy(Class<?> arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreatePropertyContextProxy$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyDoesNotExistException$str() {
        return getPropertyDoesNotExistException;
    }

    public final HibernateException getPropertyDoesNotExistException(String arg0, String arg1, ElementType arg2) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getPropertyDoesNotExistException$str(), new Object[]{arg0, arg1, arg2}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnsupportedElementTypeException$str() {
        return getUnsupportedElementTypeException;
    }

    public final HibernateException getUnsupportedElementTypeException(ElementType arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getUnsupportedElementTypeException$str(), new Object[]{arg0}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateType$str() {
        return unableToInstantiateType;
    }

    public final HibernateException unableToInstantiateType(Class<?> arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToInstantiateType$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }

    public final HibernateException unableToLoadClass(String arg0, String arg1, Exception arg2) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToLoadClass$str(), arg0, arg1), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedClassType$str() {
        return unexpectedClassType;
    }

    public final HibernateException unexpectedClassType(String arg0, Class<?> arg1, Class<?> arg2) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedClassType$str(), arg0, new ClassObjectFormatter(arg1), new ClassObjectFormatter(arg2)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedInstanceType$str() {
        return unexpectedInstanceType;
    }

    public final HibernateException unexpectedInstanceType(String arg0, String arg1, Class<?> arg2, Class<?> arg3) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedInstanceType$str(), arg0, arg1, new ClassObjectFormatter(arg2), new ClassObjectFormatter(arg3)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambigiousOptionConfiguration$str() {
        return ambigiousOptionConfiguration;
    }

    public final HibernateException ambigiousOptionConfiguration(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.ambigiousOptionConfiguration$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAssociationStorageStrategy$str() {
        return unknownAssociationStorageStrategy;
    }

    public final HibernateException unknownAssociationStorageStrategy(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unknownAssociationStorageStrategy$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalPortValue$str() {
        return illegalPortValue;
    }

    public final HibernateException illegalPortValue(int arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.illegalPortValue$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAnInteger$str() {
        return notAnInteger;
    }

    public final HibernateException notAnInteger(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.notAnInteger$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownEnumerationValue$str() {
        return unknownEnumerationValue;
    }

    public final HibernateException unknownEnumerationValue(String arg0, String arg1, String arg2) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unknownEnumerationValue$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingConfigurationProperty$str() {
        return missingConfigurationProperty;
    }

    public final HibernateException missingConfigurationProperty(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.missingConfigurationProperty$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedPropertyType$str() {
        return unsupportedPropertyType;
    }

    public final HibernateException unsupportedPropertyType(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unsupportedPropertyType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closedOperationQueue$str() {
        return closedOperationQueue;
    }

    public final HibernateException closedOperationQueue() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.closedOperationQueue$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConfigurationUrl$str() {
        return invalidConfigurationUrl;
    }

    public final HibernateException invalidConfigurationUrl(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.invalidConfigurationUrl$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str() {
        return couldNotRetrieveEntityForRetrievalOfGeneratedProperties;
    }

    public final HibernateException couldNotRetrieveEntityForRetrievalOfGeneratedProperties(String arg0, Serializable arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustNotBeNull$str() {
        return mustNotBeNull;
    }

    public final IllegalArgumentException mustNotBeNull(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustNotBeNull$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parameterMustNotBeNull$str() {
        return parameterMustNotBeNull;
    }

    public final IllegalArgumentException parameterMustNotBeNull(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parameterMustNotBeNull$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFindGridType$str() {
        return unableToFindGridType;
    }

    public final HibernateException unableToFindGridType(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToFindGridType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void dialectDoesNotSupportSequences(Class<?> arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.dialectDoesNotSupportSequences$str(), (Object)new ClassObjectFormatter(arg0), (Object)arg1);
    }

    protected String dialectDoesNotSupportSequences$str() {
        return dialectDoesNotSupportSequences;
    }

    public final void catalogOptionNotSupportedForTableGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.catalogOptionNotSupportedForTableGenerator$str(), (Object)arg0);
    }

    protected String catalogOptionNotSupportedForTableGenerator$str() {
        return catalogOptionNotSupportedForTableGenerator;
    }

    public final void schemaOptionNotSupportedForTableGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.schemaOptionNotSupportedForTableGenerator$str(), (Object)arg0);
    }

    protected String schemaOptionNotSupportedForTableGenerator$str() {
        return schemaOptionNotSupportedForTableGenerator;
    }

    public final void catalogOptionNotSupportedForSequenceGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.catalogOptionNotSupportedForSequenceGenerator$str(), (Object)arg0);
    }

    protected String catalogOptionNotSupportedForSequenceGenerator$str() {
        return catalogOptionNotSupportedForSequenceGenerator;
    }

    public final void schemaOptionNotSupportedForSequenceGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.schemaOptionNotSupportedForSequenceGenerator$str(), (Object)arg0);
    }

    protected String schemaOptionNotSupportedForSequenceGenerator$str() {
        return schemaOptionNotSupportedForSequenceGenerator;
    }

    protected String getIdentityGenerationStrategyNotSupportedException$str() {
        return getIdentityGenerationStrategyNotSupportedException;
    }

    public final HibernateException getIdentityGenerationStrategyNotSupportedException(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getIdentityGenerationStrategyNotSupportedException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void usingNonAtomicOptimisticLocking(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingNonAtomicOptimisticLocking$str(), (Object)arg0);
    }

    protected String usingNonAtomicOptimisticLocking$str() {
        return usingNonAtomicOptimisticLocking;
    }

    protected String mustNotInsertSameEntityTwice$str() {
        return mustNotInsertSameEntityTwice;
    }

    public final EntityAlreadyExistsException mustNotInsertSameEntityTwice(String arg0, Exception arg1) {
        EntityAlreadyExistsException result = new EntityAlreadyExistsException(String.format(this.getLoggingLocale(), this.mustNotInsertSameEntityTwice$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotConfigureProperty$str() {
        return couldNotConfigureProperty;
    }

    public final HibernateException couldNotConfigureProperty(String arg0, String arg1, Exception arg2) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotConfigureProperty$str(), arg0, arg1), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedLockMode$str() {
        return unsupportedLockMode;
    }

    public final HibernateException unsupportedLockMode(Class<? extends GridDialect> arg0, LockMode arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unsupportedLockMode$str(), new ClassObjectFormatter(arg0), arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void noValidDatastoreProviderShortName(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noValidDatastoreProviderShortName$str(), (Object)arg0, (Object)arg1);
    }

    protected String noValidDatastoreProviderShortName$str() {
        return noValidDatastoreProviderShortName;
    }

    protected String unableToStartDatastoreProvider$str() {
        return unableToStartDatastoreProvider;
    }

    public final ServiceException unableToStartDatastoreProvider(Exception arg0) {
        ServiceException result = new ServiceException(String.format(this.getLoggingLocale(), this.unableToStartDatastoreProvider$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureDatastoreProvider$str() {
        return unableToConfigureDatastoreProvider;
    }

    public final ServiceException unableToConfigureDatastoreProvider(Exception arg0) {
        ServiceException result = new ServiceException(String.format(this.getLoggingLocale(), this.unableToConfigureDatastoreProvider$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotLoadLuceneParserBackend$str() {
        return cannotLoadLuceneParserBackend;
    }

    public final HibernateException cannotLoadLuceneParserBackend(Exception arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotLoadLuceneParserBackend$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void unableToCloseSessionButSwallowingError(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)arg0, this.unableToCloseSessionButSwallowingError$str(), new Object[0]);
    }

    protected String unableToCloseSessionButSwallowingError$str() {
        return unableToCloseSessionButSwallowingError;
    }

    public final void jbossTransactionManagerDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jbossTransactionManagerDetected$str(), new Object[0]);
    }

    protected String jbossTransactionManagerDetected$str() {
        return jbossTransactionManagerDetected;
    }

    public final void noJtaPlatformDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.noJtaPlatformDetected$str(), new Object[0]);
    }

    protected String noJtaPlatformDetected$str() {
        return noJtaPlatformDetected;
    }

    protected String parameterSringMustNotBeEmpty$str() {
        return parameterSringMustNotBeEmpty;
    }

    public final IllegalArgumentException parameterSringMustNotBeEmpty(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parameterSringMustNotBeEmpty$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnknownAliasException$str() {
        return getUnknownAliasException;
    }

    public final HibernateException getUnknownAliasException(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getUnknownAliasException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToParseHost$str() {
        return unableToParseHost;
    }

    public final HibernateException unableToParseHost(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToParseHost$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorOnEntityBatchLoad$str() {
        return errorOnEntityBatchLoad;
    }

    public final HibernateException errorOnEntityBatchLoad(String arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.errorOnEntityBatchLoad$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notALong$str() {
        return notALong;
    }

    public final HibernateException notALong(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.notALong$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityTupleNotFound$str() {
        return entityTupleNotFound;
    }

    public final HibernateException entityTupleNotFound(String arg0, EntityKey arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.entityTupleNotFound$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failureWhenUsingAttributeConverter$str() {
        return failureWhenUsingAttributeConverter;
    }

    public final PersistenceException failureWhenUsingAttributeConverter(Class<?> arg0, Exception arg1) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.failureWhenUsingAttributeConverter$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindTypeForAttributeConverter$str() {
        return cannotFindTypeForAttributeConverter;
    }

    public final PersistenceException cannotFindTypeForAttributeConverter(Class<?> arg0, Class<?> arg1) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotFindTypeForAttributeConverter$str(), new ClassObjectFormatter(arg0), new ClassObjectFormatter(arg1)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindEntityEntryForEntity$str() {
        return cannotFindEntityEntryForEntity;
    }

    public final PersistenceException cannotFindEntityEntryForEntity(Object arg0) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotFindEntityEntryForEntity$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String transactionIdIsNotAvailable$str() {
        return transactionIdIsNotAvailable;
    }

    public final HibernateException transactionIdIsNotAvailable() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.transactionIdIsNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tupleContextNotAvailable$str() {
        return tupleContextNotAvailable;
    }

    public final HibernateException tupleContextNotAvailable() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.tupleContextNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void usingDeprecatedDatastoreProviderName(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingDeprecatedDatastoreProviderName$str(), (Object)arg0, (Object)arg1);
    }

    protected String usingDeprecatedDatastoreProviderName$str() {
        return usingDeprecatedDatastoreProviderName;
    }

    protected String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str() {
        return queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass;
    }

    public final HibernateException queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass(String arg0, Collection<String> arg1) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

