/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.infinispan.impl.TransactionManagerLookupDelegator;
import org.hibernate.ogm.datastore.infinispan.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispan.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.ExternalizersIntegration;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.InfinispanConfigurationParser;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

public abstract class LocalCacheManager<EK, AK, ISK> {
    private static final Log LOG = LoggerFactory.getLogger();
    private final EmbeddedCacheManager cacheManager;
    private final boolean isProvidedCacheManager;

    protected LocalCacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.isProvidedCacheManager = true;
    }

    protected LocalCacheManager(URL configUrl, JtaPlatform platform, Set<String> cacheNames, KeyProvider<EK, AK, ISK> keyProvider) {
        this.cacheManager = LocalCacheManager.createCustomCacheManager(configUrl, platform, cacheNames, keyProvider);
        this.isProvidedCacheManager = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EmbeddedCacheManager createCustomCacheManager(URL configUrl, JtaPlatform platform, Set<String> cacheNames, KeyProvider<?, ?, ?> keyProvider) {
        DefaultCacheManager defaultCacheManager;
        block8: {
            HashSet<String> allCacheNames = new HashSet<String>();
            allCacheNames.addAll(cacheNames);
            TransactionManagerLookupDelegator transactionManagerLookupDelegator = new TransactionManagerLookupDelegator(platform);
            InputStream configurationFile = configUrl.openStream();
            try {
                InfinispanConfigurationParser ispnConfiguration = new InfinispanConfigurationParser();
                ConfigurationBuilderHolder configurationBuilderHolder = ispnConfiguration.parseFile(configurationFile);
                DefaultCacheManager tmpCacheManager = new DefaultCacheManager(configurationBuilderHolder, false);
                SerializationConfigurationBuilder serializationConfiguration = new GlobalConfigurationBuilder().read(tmpCacheManager.getCacheManagerConfiguration()).serialization();
                ExternalizersIntegration.registerOgmExternalizers(serializationConfiguration);
                allCacheNames.addAll(tmpCacheManager.getCacheNames());
                GlobalConfiguration globalConfiguration = serializationConfiguration.build();
                Configuration defaultCacheConfiguration = LocalCacheManager.defaultCacheConfiguration(transactionManagerLookupDelegator, (EmbeddedCacheManager)tmpCacheManager, globalConfiguration);
                DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfiguration, defaultCacheConfiguration, false);
                for (String cacheName : allCacheNames) {
                    if (LocalCacheManager.isDefaultCacheName(globalConfiguration, cacheName)) continue;
                    Configuration config = tmpCacheManager.getCacheConfiguration(cacheName);
                    config = config == null ? defaultCacheConfiguration : LocalCacheManager.updateConfiguration(cacheName, transactionManagerLookupDelegator, config);
                    if (config == null) {
                        throw LOG.missingCacheConfiguration(cacheName);
                    }
                    cacheManager.defineConfiguration(cacheName, config);
                }
                cacheManager.start();
                defaultCacheManager = cacheManager;
                if (configurationFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (configurationFile != null) {
                        configurationFile.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw LocalCacheManager.raiseConfigurationError(e, configUrl.toString());
                }
            }
            configurationFile.close();
        }
        return defaultCacheManager;
    }

    private static Configuration defaultCacheConfiguration(TransactionManagerLookupDelegator transactionManagerLookupDelegator, EmbeddedCacheManager tmpCacheManager, GlobalConfiguration globalConfiguration) {
        if (tmpCacheManager.getDefaultCacheConfiguration() != null) {
            String defaultCacheName = globalConfiguration.defaultCacheName().orElse(null);
            return LocalCacheManager.updateConfiguration(defaultCacheName, transactionManagerLookupDelegator, tmpCacheManager.getDefaultCacheConfiguration());
        }
        return null;
    }

    private static Configuration updateConfiguration(String cacheName, TransactionManagerLookupDelegator transactionManagerLookupDelegator, Configuration configuration) {
        Configuration newConfiguration = LocalCacheManager.enableClusteringHashGroups(cacheName, configuration);
        newConfiguration = LocalCacheManager.injectTransactionManager(transactionManagerLookupDelegator, newConfiguration);
        return newConfiguration;
    }

    private static boolean isDefaultCacheName(GlobalConfiguration globalConfiguration, String cacheName) {
        String defaultCacheName = globalConfiguration.defaultCacheName().orElse(null);
        return cacheName.equals(defaultCacheName);
    }

    private static Configuration enableClusteringHashGroups(String cacheName, Configuration configuration) {
        if (configuration.clustering().hash().groups().enabled()) {
            return configuration;
        }
        LOG.clusteringHashGroupsMustBeEnabled(cacheName);
        ConfigurationBuilder builder = new ConfigurationBuilder().read(configuration);
        builder.clustering().hash().groups().enabled();
        return builder.build();
    }

    private static Configuration injectTransactionManager(TransactionManagerLookupDelegator transactionManagerLookupDelegator, Configuration configuration) {
        if (configuration.transaction().transactionMode() == TransactionMode.TRANSACTIONAL) {
            ConfigurationBuilder builder = new ConfigurationBuilder().read(configuration);
            builder.transaction().transactionManagerLookup((TransactionManagerLookup)transactionManagerLookupDelegator);
            return builder.build();
        }
        return configuration;
    }

    private static HibernateException raiseConfigurationError(Exception e, String cfgName) {
        return new HibernateException("Could not start Infinispan CacheManager using as configuration file: " + cfgName, (Throwable)e);
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void stop() {
        if (!this.isProvidedCacheManager) {
            this.cacheManager.stop();
        }
    }

    public abstract Cache<EK, Map<String, Object>> getEntityCache(EntityKeyMetadata var1);

    public abstract Cache<AK, Map<RowKey, Map<String, Object>>> getAssociationCache(AssociationKeyMetadata var1);

    public abstract Cache<ISK, Object> getIdSourceCache(IdSourceKeyMetadata var1);

    public abstract Set<Bucket<EK>> getWorkBucketsFor(EntityKeyMetadata ... var1);

    public static class Bucket<EK> {
        private final Cache<EK, Map<String, Object>> cache;
        private final EntityKeyMetadata[] entityKeyMetadatas;

        public Bucket(Cache<EK, Map<String, Object>> cache, List<EntityKeyMetadata> entityKeyMetadatas) {
            this.cache = cache;
            this.entityKeyMetadatas = entityKeyMetadatas.toArray(new EntityKeyMetadata[entityKeyMetadatas.size()]);
        }

        public Bucket(Cache<EK, Map<String, Object>> cache, EntityKeyMetadata ... entityKeyMetadatas) {
            this.cache = cache;
            this.entityKeyMetadatas = entityKeyMetadatas;
        }

        public Cache<EK, Map<String, Object>> getCache() {
            return this.cache;
        }

        public EntityKeyMetadata[] getEntityKeyMetadata() {
            return this.entityKeyMetadatas;
        }
    }
}

