/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.mongodb.MongoDBDialect;
import org.hibernate.ogm.logging.mongodb.impl.Log;
import org.hibernate.ogm.logging.mongodb.impl.LoggerFactory;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class MongoDBDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable,
Configurable {
    private static final Log log = LoggerFactory.getLogger();
    private Map<?, ?> cfg;
    private boolean isCacheStarted;
    private Mongo mongo;
    private DB mongoDb;
    private AssociationStorage associationStorage;

    public void configure(Map configurationValues) {
        this.cfg = configurationValues;
        String assocStoreString = (String)this.cfg.get("hibernate.ogm.mongodb.associations.store");
        if (assocStoreString == null) {
            this.associationStorage = AssociationStorage.IN_ENTITY;
        } else {
            try {
                this.associationStorage = AssociationStorage.valueOf(assocStoreString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                log.unknownAssociationStorageStrategy(assocStoreString, AssociationStorage.class);
            }
        }
    }

    public AssociationStorage getAssociationStorage() {
        return this.associationStorage;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return MongoDBDialect.class;
    }

    public void start() {
        if (!this.isCacheStarted) {
            Object cfgHost = this.cfg.get("hibernate.ogm.mongodb.host");
            String host = cfgHost != null ? cfgHost.toString() : "127.0.0.1";
            try {
                int port;
                Object cfgPort = this.cfg.get("hibernate.ogm.mongodb.port");
                if (cfgPort != null) {
                    try {
                        int temporaryPort = Integer.valueOf(cfgPort.toString());
                        if (temporaryPort < 1 || temporaryPort > 65535) {
                            throw log.mongoPortIllegalValue(cfgPort.toString());
                        }
                        port = temporaryPort;
                    }
                    catch (NumberFormatException e) {
                        throw log.mongoPortIllegalValue(cfgPort.toString());
                    }
                } else {
                    port = 27017;
                }
                Object cfgSafe = this.cfg.get("hibernate.ogm.mongodb.safe");
                boolean safe = true;
                if (cfgSafe != null) {
                    safe = Boolean.parseBoolean(cfgSafe.toString());
                }
                Object cfgTimeout = this.cfg.get("hibernate.ogm.mongodb.connection_timeout");
                int timeout = 5000;
                if (cfgTimeout != null) {
                    try {
                        int temporaryTimeout = Integer.valueOf(cfgTimeout.toString());
                        if (temporaryTimeout < 0) {
                            throw log.mongoDBTimeOutIllegalValue(cfgTimeout.toString());
                        }
                        timeout = temporaryTimeout;
                    }
                    catch (NumberFormatException e) {
                        throw log.mongoDBTimeOutIllegalValue(cfgTimeout.toString());
                    }
                }
                MongoOptions options = new MongoOptions();
                options.safe = safe;
                options.connectTimeout = timeout;
                log.useSafe(safe);
                log.connectingToMongo(host, port, timeout);
                ServerAddress serverAddress = new ServerAddress(host, port);
                this.mongo = new Mongo(serverAddress, options);
                this.isCacheStarted = true;
            }
            catch (UnknownHostException e) {
                throw log.mongoOnUnknownHost(host);
            }
            catch (RuntimeException e) {
                throw log.unableToInitializeMongoDB(e);
            }
            this.mongoDb = this.extractDatabase();
        }
    }

    public void stop() {
        log.disconnectingFromMongo();
        this.mongo.close();
    }

    public DB getDatabase() {
        return this.mongoDb;
    }

    private DB extractDatabase() {
        try {
            Object passwordObject;
            String password;
            String username;
            DB admin;
            boolean auth;
            Object dbNameObject = this.cfg.get("hibernate.ogm.mongodb.database");
            if (dbNameObject == null) {
                throw log.mongoDbNameMissing();
            }
            String dbName = (String)dbNameObject;
            log.connectingToMongoDatabase(dbName);
            Object usernameObject = this.cfg.get("hibernate.ogm.mongodb.username");
            if (usernameObject != null && !(auth = (admin = this.mongo.getDB("admin")).authenticate(username = usernameObject.toString(), (password = (passwordObject = this.cfg.get("hibernate.ogm.mongodb.password")) != null ? passwordObject.toString() : "").toCharArray()))) {
                throw log.authenticationFailed(username);
            }
            if (!this.mongo.getDatabaseNames().contains(dbName)) {
                log.creatingDatabase(dbName);
            }
            return this.mongo.getDB(dbName);
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw log.unableToConnectToDatastore(this.mongo.getAddress().getHost(), this.mongo.getAddress().getPort(), e);
        }
    }
}

